/*
 * 作成日 : 2008/04/09
 *
 * Copyright 2008 Project Tsukuyomi. All rights reserved. 
 */
package jp.sourceforge.tsukuyomi.japanese;

/**
 * 仮名に関するユーティリティクラスです。
 * 
 * @author itoasuka
 */
public class KanaUtils {
	/**
	 * ユーティリティクラスであるため何もしません。
	 */
	private KanaUtils() {
		// 何もしない
	}

	/**
	 * ひらがなをカタカナに変換します。
	 * 
	 * @param src
	 *            変換対象の文字列
	 * @return 変換後の文字列
	 */
	public static String toKatakana(String src) {
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < src.length(); i++) {
			char c = src.charAt(i);

			if ('\u3040' <= c && c <= '\u309F') {
				sb.append((char) (c - '\u3040' + '\u30A0'));
			} else {
				sb.append(c);
			}
		}

		return sb.toString();
	}

	/**
	 * カタカナをひらがなに変換します。
	 * 
	 * @param src
	 *            変換対象の文字列
	 * @return 変換後の文字列
	 */
	public static String toHiragana(String src) {
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < src.length(); i++) {
			char c = src.charAt(i);

			if ('\u30A0' <= c && c <= '\u30FF') {
				sb.append((char) (c - '\u30A0' + '\u3040'));
			} else {
				sb.append(c);
			}
		}

		return sb.toString();
	}
	

	/**
	 * 指定した文字が半角カナかを取得します。
	 * 
	 * @param c 半角カナかを調べる文字
	 * @return 半角カナのとき <code>true</code>
	 * @since 0.1.1
	 */
	public static boolean isHalfWidthKana(char c) {
		return '\uff61' <= c && c <= '\uff9f';
	}
}
