/*
 * StringConvertException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

/**
 * ̕ύXȂꍇɃX[ONXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:53 $
 */
public class StringConvertException extends Exception
{
  /* VAԍB */
  static final long serialVersionUID = 1584378524238190509L;

  /** ύXfꂽCfbNXB */
  private int stoppedIndex_ = 0;

  /** f܂ŕύXꂽB */
  private String convertedString_ = "";

  /**
   * ύXfꂽCfbNXƁAf܂ŕϊꂽ
   * ƂRXgN^B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|CgPʂ̒lłB
   *
   * @param  index  ύXfꂽCfbNXB
   * @param  converted  f܂ŕϊꂽB
   */
  public StringConvertException(int index, CharSequence converted)
  {
    stoppedIndex_ = index;
    convertedString_ = (converted == null) ? null : converted.toString();
  }

  /**
   * ύXfꂽCfbNXƁAf܂ŕϊꂽƁA
   * ObZ[WɂƂRXgN^B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|CgPʂ̒lłB
   *
   * @param  index  ύXfꂽCfbNXB
   * @param  converted  f܂ŕϊꂽB
   * @param  msg ObZ[WB
   */
  public StringConvertException(int index, CharSequence converted, String msg)
  {
    super(msg);

    stoppedIndex_ = index;
    convertedString_ = (converted == null) ? null : converted.toString();
  }

  /**
   * ύXfꂽCfbNX擾B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|CgPʂ̒lłB
   *
   * @return ύXfꂽCfbNXB
   */
  public int getStoppedIndex()
  {
    return stoppedIndex_ ;
  }

  /**
   * f܂ŕϊꂽ擾B
   *
   * @return f܂ŕϊꂽB
   */
  public String convertedString()
  {
    return convertedString_ ;
  }
}

