/*
 * FileSizeFilterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.ObjectInspector;
import java.io.File;
import java.io.FileFilter;

/**
 * {@link ts.util.file.FileSizeFilter FileSizeFilter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:47 $
 */
public class FileSizeFilterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileSizeFilterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileSizeFilter NX̋@\sB");
  }

  private ObjectInspector oi_ = new ObjectInspector(this);

  protected void preInvocation(String methodName)
  {
    oi_.expect("sizeFrom_", -1L);
    oi_.expect("sizeTo_", -1L);
  }
  
  /* -- test case -- */

  public void constructor_sizeFrom_sizeTo()
  {
    MSG("t@CETCY͈̔͂ɂƂRXgN^B");

    FileSizeFilter filter = new FileSizeFilter(1024L, 2048L);
    oi_.expect("sizeFrom_", 1024L);
    oi_.expect("sizeTo_", 2048L);
    oi_.inspect(filter);

    filter = new FileSizeFilter(512L, -512L);
    oi_.expect("sizeFrom_", 512L);
    oi_.expect("sizeTo_", -1L);
    oi_.inspect(filter);

    filter = new FileSizeFilter(-64L, 64L);
    oi_.expect("sizeFrom_", -1L);
    oi_.expect("sizeTo_", 64L);
    oi_.inspect(filter);

    filter = new FileSizeFilter(-256L, -16L);
    oi_.expect("sizeFrom_", -1L);
    oi_.expect("sizeTo_", -1L);
    oi_.inspect(filter);

    filter = new FileSizeFilter(1024L, 512L);
    oi_.expect("sizeFrom_", 512L);
    oi_.expect("sizeTo_", 1024L);
    oi_.inspect(filter);
  }

  public void accept()
  {
    MSG("t@CETCYY邩ǂ̔̊mFB");

    FileSizeFilter filter = new FileSizeFilter(5000L, 8000L);
    TRUE(filter.accept(new File("./build.xml")));

    filter = new FileSizeFilter(6500L, 8000L);
    FALSE(filter.accept(new File("./build.xml")));

    filter = new FileSizeFilter(-1L, 8000L);
    TRUE(filter.accept(new File("./build.xml")));

    filter = new FileSizeFilter(6000L, 6000L);
    FALSE(filter.accept(new File("./build.xml")));

    filter = new FileSizeFilter(4000L, -1L);
    TRUE(filter.accept(new File("./build.xml")));

    filter = new FileSizeFilter(-1L, -1L);
    TRUE(filter.accept(new File("./build.xml")));
  }

  public void accept_1()
  {
    MSG("k̏ꍇB");

    FileSizeFilter filter = new FileSizeFilter(1024L, 2048L);
    try {
      filter.accept(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

