/*
 * TypedMap class.
 *
 * Copyright (C) 2011 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;

/**
 * L[ɌтꂽlIuWFNg^ϊĎ擾邽߂̃\bh
 * }bvENXB
 *
 * @author V
 * @version $Id: TypedMap.java,v 1.4 2011-08-01 15:29:30 tayu Exp $
 */
public class TypedMap<K,V> extends AbstractTypedGetter<K,V> implements Map<K,V>
{
  /** VAEo[WԍB */
  static final long serialVersionUID = 8641045995393252723L;

  /** L[ƒlIuWFNg̃}bsOi[}bvB */
  private final Map<K,V> innerMap = createInnerMap();

  /**
   * ftHgERXgN^B
   */
  public TypedMap()
  {}

  /**
   * }bv쐬B
   *
   * @return }bvB
   */
  protected Map<K,V> createInnerMap()
  {
    return new HashMap<K,V>();
  }

  /**
   * ̃}bvɊi[Ăvf̐擾B
   *
   * @return ̃}bvɊi[Ăvf̐B
   */
  @Override
  public int size()
  {
    return this.innerMap.size();
  }

  /**
   * ̃}bv󂩂ǂmFB
   *
   * @return ̃}bv̗vf[̏ꍇ<tt>true</tt>ԂB
   */
  @Override
  public boolean isEmpty()
  {
    return this.innerMap.isEmpty();
  }

  /**
   * w肳ꂽL[vf̃}bvɑ݂邩ǂmFB
   * 
   * @param key L[B
   * @return ̃L[̃}bvɊ܂܂Ăꍇ<tt>true</tt>ԂB
   */
  @Override
  public boolean containsKey(Object key)
  {
    return this.innerMap.containsKey(key);
  }

  /**
   * w肳ꂽlIuWFNgvf̃}bvɑ݂邩ǂmF
   * B
   *
   * @param value lIuWFNgB
   * @return ̒lIuWFNg̃}bvɊ܂܂Ăꍇ<tt>true</tt>
   *         ԂB
   */
  @Override
  public boolean containsValue(Object value)
  {
    return this.innerMap.containsValue(value);
  }

  /**
   * w肳ꂽL[ɌтĂlIuWFNg擾B
   * <br>
   * тꂽlIuWFNg݂Ȃꍇ̓kԂB
   *
   * @param key L[B
   * @return ̃L[ɌтĂlIuWFNgB
   */
  @Override
  public V get(Object key)
  {
    return this.innerMap.get(key);
  }

  /**
   * w肳ꂽL[ƒlIuWFNg̑g̃}bvɓo^B
   *
   * @param key L[B
   * @param value lIuWFNgB
   * @return ̃L[ɈȑOтĂlIuWFNgB
   */
  @Override
  public V put(K key, V value)
  {
    return this.innerMap.put(key, value);
  }

  /**
   * w肳ꂽL[ɌтĂlIuWFNg폜B
   *
   * @param key L[B
   * @return ̃L[ɈȑOт炒ĂlIuWFNgB
   */
  @Override
  public V remove(Object key)
  {
    return this.innerMap.remove(key);
  }

  /**
   * w肳ꂽ}bv̑SĂ̗vf̃}bvɒǉB 
   *
   * @param map ǉvfi[}bvB
   */
  @Override
  public void putAll(Map<? extends K, ? extends V> map)
  {
    this.innerMap.putAll(map);
  }

  /**
   * ̃}bvɂB
   * <br>
   * ̃}bv̑SĂ̗vfÃ}bv폜B
   */
  @Override
  public void clear()
  {
    this.innerMap.clear();
  }

  /**
   * ̃}bvi[ĂL[̏W擾B
   *
   * @return ̃}bvi[ĂL[̏WB
   */
  @Override
  public Set<K> keySet()
  {
    return this.innerMap.keySet();
  }

  /**
   * ̃}bv̑SĂ̗vf̒lIuWFNgi[RNVEIuWFNg
   * 擾B
   *
   * @return ̃}bv̑SĂ̗vf̒lIuWFNgi[RNVE
   *         IuWFNgB
   */
  @Override
  public Collection<V> values()
  {
    return this.innerMap.values();
  }

  /**
   * ̃}bvɊi[ĂSẴL[ƒl̑gA{@link java.util.Map.Entry}
   * IuWFNg̏WƂĎ擾B
   *
   * @return ̃}bv̑SĂ̗vfi[WB
   */
  @Override
  public Set<Map.Entry<K,V>> entrySet()
  {
    return this.innerMap.entrySet();
  }

  /**
   * w肳ꂽIuWFNgƓeǂrB
   * <br>
   * ̃IuWFNg}bvłÃ}bvƈ̃}bv}bsO
   * Ăꍇ<tt>true</tt>ԂB
   * ̓Iɂ́Ã}bv{@link Map#entrySet()}\bȟʂƈ
   * }bv{@link Map#entrySet()}̌ʂꍇ<tt>true</tt>ԂB
   *
   * @param obj rIuWFNgB
   * @return ̃IuWFNg̃}bvƓeꍇ<tt>true</tt>B
   */
  @Override
  public boolean equals(Object obj)
  {
    return this.innerMap.equals(obj);
  }

  /**
   * ̃}bvɑ΂nbVER[h擾B
   *
   * @return ̃}bvɑ΂nbVER[hB
   */
  @Override
  public int hashCode()
  {
    return this.innerMap.hashCode();
  }
}
