/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.coverage;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import ts.tester.util.ObjectSerializer;

public class ObjectWriter {
    private static final char START_CHAR = '\u0002';
    private static final char END_CHAR = '\u0003';
    private static final char ESC_CHAR = '\u001b';
    private StringBuffer objBuf_ = null;
    private static final Null NULL = new Null();
    private OutputStreamWriter streamWriter_ = null;

    public static void prepareOutput() {
        System.setOut(new ObjectPrintStream(System.out));
        System.setErr(new ObjectPrintStream(System.err));
    }

    public static void outputObject(Serializable serializable) throws InvalidClassException, IOException {
        if (serializable == null) {
            serializable = NULL;
        }
        String string = ObjectSerializer.serializeToString(serializable);
        PrintStream printStream = System.out;
        if (System.out instanceof ObjectPrintStream) {
            ObjectPrintStream objectPrintStream = (ObjectPrintStream)System.out;
            printStream = objectPrintStream.getBarePrintStream();
        }
        printStream.print('\u0002' + string + '\u0003');
        printStream.flush();
    }

    void setStreamWriter(OutputStreamWriter outputStreamWriter) {
        this.streamWriter_ = outputStreamWriter;
    }

    final void writeObjectOrStream(char[] cArray, int n) throws ClassNotFoundException, IOException {
        assert (cArray != null) : "@param:cBuf is null.";
        assert (n >= 0) : "@param:len is negative.";
        assert (n <= cArray.length) : "@param:len is too large.";
        assert (this.streamWriter_ != null) : "@param:streamWriter_ is null.";
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuilder.append(cArray[i]);
                bl = false;
                continue;
            }
            if (cArray[i] == '\u001b') {
                if (this.objBuf_ == null) {
                    bl = true;
                    continue;
                }
                this.objBuf_.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '\u0002') {
                if (this.objBuf_ == null && stringBuilder.length() > 0) {
                    this.streamWriter_.write(stringBuilder.toString());
                    this.streamWriter_.flush();
                }
                this.objBuf_ = new StringBuffer();
                continue;
            }
            if (cArray[i] == '\u0003') {
                if (this.objBuf_ != null) {
                    Object object = ObjectSerializer.deserialize(this.objBuf_.toString());
                    this.writeObject(object instanceof Null ? null : object);
                    this.objBuf_ = null;
                }
                stringBuilder = new StringBuilder();
                continue;
            }
            if (this.objBuf_ != null) {
                this.objBuf_.append(cArray[i]);
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        if (this.objBuf_ == null && stringBuilder.length() > 0) {
            this.streamWriter_.write(stringBuilder.toString());
            this.streamWriter_.flush();
        }
    }

    protected void writeObject(Object object) {
    }

    private static class ObjectPrintStream
    extends PrintStream {
        private PrintStream printStream_;

        public ObjectPrintStream(PrintStream printStream) {
            super(printStream);
            this.printStream_ = printStream;
        }

        PrintStream getBarePrintStream() {
            return this.printStream_;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            int n3 = n2;
            for (int i = n; i < n + n2; ++i) {
                switch (byArray[i]) {
                    case 2: 
                    case 3: 
                    case 27: {
                        ++n3;
                    }
                }
            }
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                switch (byArray[n4]) {
                    case 2: 
                    case 3: 
                    case 27: {
                        byArray2[n5] = 27;
                        ++n5;
                    }
                }
                byArray2[n5] = byArray[n4];
                ++n4;
                ++n5;
            }
            super.write(byArray2, 0, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) {
            switch (n) {
                case 2: 
                case 3: 
                case 27: {
                    ObjectPrintStream objectPrintStream = this;
                    synchronized (objectPrintStream) {
                        super.write(27);
                        super.write(n);
                        break;
                    }
                }
                default: {
                    super.write(n);
                }
            }
        }
    }

    private static class Null
    implements Serializable {
        static final long serialVersionUID = 862525238995100138L;

        private Null() {
        }
    }
}

