/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import ts.util.resource.AttributeNameEmptyException;
import ts.util.resource.AttributeNoCloseParException;
import ts.util.resource.AttributeNoMatchMarkException;
import ts.util.resource.ElementBadEndCharException;
import ts.util.resource.ElementNameEmptyException;
import ts.util.resource.IllegalKeyException;
import ts.util.resource.Resource;
import ts.util.text.StringOperation;
import ts.util.text.StringSequence;

public abstract class AbstractResource
implements Resource {
    private String elementSeparator_ = ".";
    private String[] attributeParenthesis_ = new String[]{"(", ")"};
    private String attributeSeparator_ = ",";
    private String attributeMatchMark_ = "=";
    private String path_ = null;

    public AbstractResource() {
    }

    public AbstractResource(AbstractResource abstractResource) {
        assert (abstractResource != null) : "@param:res is null.";
        this.setElementSeparator(abstractResource.elementSeparator());
        this.setAttributeSeparator(abstractResource.attributeSeparator());
        this.setAttributeMatchMark(abstractResource.attributeMatchMark());
        String[] stringArray = abstractResource.attributeParenthesis();
        this.setAttributeParenthesis(stringArray[0], stringArray[1]);
        this.path_ = abstractResource.path_;
    }

    @Deprecated
    protected void setElementSeparator(char c) {
        this.elementSeparator_ = String.valueOf(c);
    }

    protected void setElementSeparator(String string) {
        assert (string != null) : "@param:separator is null.";
        if (StringOperation.length(string) != 1) {
            throw new IllegalArgumentException("@param:separator is not a charactor.");
        }
        this.elementSeparator_ = string;
    }

    @Deprecated
    public char getElementSeparator() {
        return this.elementSeparator_.charAt(0);
    }

    public String elementSeparator() {
        return this.elementSeparator_;
    }

    @Deprecated
    protected void setAttributeParenthesis(char c, char c2) {
        this.attributeParenthesis_[0] = String.valueOf(c);
        this.attributeParenthesis_[1] = String.valueOf(c2);
    }

    protected void setAttributeParenthesis(String string, String string2) {
        assert (string != null) : "@param:openPar is null.";
        assert (string2 != null) : "@param:closePar is null.";
        if (StringOperation.length(string) != 1) {
            throw new IllegalArgumentException("@param:openPar is not a charactor.");
        }
        if (StringOperation.length(string2) != 1) {
            throw new IllegalArgumentException("@param:closePar is not a charactor.");
        }
        this.attributeParenthesis_[0] = string;
        this.attributeParenthesis_[1] = string2;
    }

    @Deprecated
    public char[] getAttributeParenthesis() {
        char[] cArray = new char[]{this.attributeParenthesis_[0].charAt(0), this.attributeParenthesis_[1].charAt(0)};
        return cArray;
    }

    public String[] attributeParenthesis() {
        return this.attributeParenthesis_;
    }

    @Deprecated
    protected void setAttributeSeparator(char c) {
        this.attributeSeparator_ = String.valueOf(c);
    }

    protected void setAttributeSeparator(String string) {
        assert (string != null) : "@param:separator is null.";
        if (StringOperation.length(string) != 1) {
            throw new IllegalArgumentException("@param:separator is not a charactor.");
        }
        this.attributeSeparator_ = string;
    }

    @Deprecated
    public char getAttributeSeparator() {
        return this.attributeSeparator_.charAt(0);
    }

    public String attributeSeparator() {
        return this.attributeSeparator_;
    }

    @Deprecated
    protected void setAttributeMatchMark(char c) {
        this.attributeMatchMark_ = String.valueOf(c);
    }

    protected void setAttributeMatchMark(String string) {
        assert (string != null) : "@param:mark is null.";
        if (StringOperation.length(string) != 1) {
            throw new IllegalArgumentException("@param:mark is not a charactor.");
        }
        this.attributeMatchMark_ = string;
    }

    @Deprecated
    public char getAttributeMatchMark() {
        return this.attributeMatchMark_.charAt(0);
    }

    public String attributeMatchMark() {
        return this.attributeMatchMark_;
    }

    protected String getNameOfKeyElement(String string) {
        assert (string != null) : "@param:keyElem is null.";
        int n = StringOperation.indexOf(string, this.attributeParenthesis()[0]);
        return n < 0 ? string : StringOperation.substring(string, 0, n);
    }

    protected List<String[]> listAttributesOfKeyElement(String string) {
        assert (string != null) : "@param:keyElem is null";
        int n = StringOperation.length(this.attributeParenthesis()[0]);
        int n2 = StringOperation.length(this.attributeParenthesis()[1]);
        int n3 = StringOperation.length(this.attributeSeparator());
        int n4 = StringOperation.length(this.attributeMatchMark());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StringSequence stringSequence = new StringSequence(string);
        if (!stringSequence.nextUntil(this.attributeParenthesis()[0]).validIndex()) {
            return arrayList;
        }
        StringSequence stringSequence2 = stringSequence.copy();
        String[] stringArray = new String[2];
        while (stringSequence.validIndex()) {
            if (stringArray[0] == null && stringSequence.startsWith(this.attributeMatchMark())) {
                stringArray[0] = stringSequence2.followingString(stringSequence);
                stringSequence.next(n4 - 1);
                stringSequence2 = stringSequence.copy();
            } else if (stringSequence.startsWith(this.attributeSeparator())) {
                stringArray[1] = stringSequence2.followingString(stringSequence);
                arrayList.add(stringArray);
                stringArray = new String[2];
                stringSequence.next(n3 - 1);
                stringSequence2 = stringSequence.copy();
            } else if (stringSequence.startsWith(this.attributeParenthesis()[1])) break;
            stringSequence.next();
        }
        stringArray[1] = stringSequence2.followingString(stringSequence);
        arrayList.add(stringArray);
        return arrayList;
    }

    protected List<String> splitKey(String string) throws IllegalKeyException {
        String string2;
        assert (string != null) : "@param:key is null.";
        int n = StringOperation.length(this.elementSeparator());
        int n2 = StringOperation.length(this.attributeSeparator());
        int n3 = StringOperation.length(this.attributeParenthesis()[0]);
        int n4 = StringOperation.length(this.attributeParenthesis()[1]);
        int n5 = StringOperation.length(this.attributeMatchMark());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringOperation.isEmpty(string)) {
            return arrayList;
        }
        StringSequence stringSequence = new StringSequence(string, -1);
        StringSequence stringSequence2 = stringSequence.copy();
        stringSequence.next();
        block0: while (stringSequence.validIndex()) {
            block19: {
                if (stringSequence.startsWith(this.elementSeparator())) {
                    string2 = stringSequence2.followingString(stringSequence);
                    if (StringOperation.isEmpty(string2)) {
                        throw new ElementNameEmptyException(string);
                    }
                    arrayList.add(string2);
                    stringSequence.next(n - 1);
                    stringSequence2 = stringSequence.copy();
                } else if (stringSequence.startsWith(this.attributeParenthesis()[0])) {
                    string2 = stringSequence2.followingString(stringSequence);
                    if (StringOperation.isEmpty(string2)) {
                        throw new ElementNameEmptyException(string);
                    }
                    stringSequence.next(n3 - 1);
                    StringSequence stringSequence3 = stringSequence.copy();
                    boolean bl = false;
                    while (stringSequence.validIndex()) {
                        String string3;
                        if (!bl && stringSequence.startsWith(this.attributeMatchMark())) {
                            string3 = stringSequence3.followingString(stringSequence);
                            if (StringOperation.isEmpty(string3)) {
                                throw new AttributeNameEmptyException(string);
                            }
                            bl = true;
                            stringSequence.next(n5 - 1);
                        } else if (stringSequence.startsWith(this.attributeSeparator())) {
                            if (!bl) {
                                throw new AttributeNoMatchMarkException(string);
                            }
                            bl = false;
                            stringSequence.next(n2 - 1);
                            stringSequence3 = stringSequence.copy();
                        } else if (stringSequence.startsWith(this.attributeParenthesis()[1])) {
                            if (!bl) {
                                throw new AttributeNoMatchMarkException(string);
                            }
                            bl = false;
                            if (!stringSequence.next(n4).validIndex()) break block0;
                            string3 = stringSequence2.followingString(stringSequence);
                            arrayList.add(string3);
                            if (!stringSequence.startsWith(this.elementSeparator())) {
                                throw new ElementBadEndCharException(string);
                            }
                            stringSequence2 = stringSequence.copy();
                            break block19;
                        }
                        stringSequence.next();
                    }
                    throw new AttributeNoCloseParException(string);
                }
            }
            stringSequence.next();
        }
        if (StringOperation.isEmpty(string2 = stringSequence2.followingString(stringSequence))) {
            throw new ElementNameEmptyException(string);
        }
        arrayList.add(string2);
        return arrayList;
    }

    public String getPath() {
        return this.path_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(String string) throws FileNotFoundException, IOException {
        assert (string != null) : "@param:path is null.";
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string);
            this.load(inputStream);
            this.path_ = string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected InputStream getInputStream(String string) throws FileNotFoundException, IOException {
        assert (string != null) : "@param:path is null.";
        return new FileInputStream(string);
    }

    protected abstract void load(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(String string) throws IOException {
        assert (string != null) : "@param:path is null.";
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(string);
            this.save(outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected OutputStream getOutputStream(String string) throws IOException {
        assert (string != null) : "@param:path is null.";
        return new FileOutputStream(string);
    }

    protected abstract void save(OutputStream var1) throws IOException;
}

