/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import ts.util.AbstractTypedGetter;

public class QueryParam
extends AbstractTypedGetter<String, Serializable> {
    private static final long serialVersionUID = -7316624337998775137L;
    private final String name;
    private final IO io;
    private Serializable value = null;
    private Iterator<Serializable> iterator = null;
    private Collection<Serializable> collection = null;
    private HashMap<String, Serializable> attrMap = null;

    public QueryParam(String string) {
        this(string, IO.IN);
    }

    public QueryParam(String string, IO iO) {
        assert (string != null && iO != null) : string == null ? "@param:name is null." : (iO == null ? "@param:io is null." : "");
        this.name = string;
        this.io = iO;
    }

    public String getName() {
        return this.name;
    }

    public IO getIO() {
        return this.io;
    }

    public Serializable get(String string) {
        return this.attrMap == null ? null : this.attrMap.get(string);
    }

    public Object put(String string, Serializable serializable) {
        if (this.attrMap == null) {
            this.attrMap = new HashMap();
        }
        if (serializable == null) {
            return this.attrMap.remove(string);
        }
        return this.attrMap.put(string, serializable);
    }

    public void setValue(Object object) {
        if (object == null) {
            this.value = null;
            this.collection = null;
            this.iterator = null;
        } else if (object instanceof Collection) {
            this.value = null;
            this.collection = this.toCollection(object);
            this.iterator = this.collection.iterator();
        } else if (object instanceof Serializable[]) {
            this.value = null;
            this.collection = Arrays.asList((Object[])Serializable[].class.cast(object));
            this.iterator = this.collection.iterator();
        } else {
            this.value = (Serializable)Serializable.class.cast(object);
            this.collection = null;
            this.iterator = null;
        }
    }

    public Object getValue() {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.value = this.iterator.next();
        }
        return this.value;
    }

    public int countValues() {
        return this.collection == null ? 1 : this.collection.size();
    }

    protected Collection<Serializable> toCollection(Object object) {
        return (Collection)object;
    }

    public static enum IO {
        IN,
        OUT,
        INOUT;

    }
}

