/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ts.query.QueryConnection;
import ts.query.QueryConnectionFactory;
import ts.query.QueryResultList;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class DefaultQueryTransaction
implements QueryTransaction {
    private QueryTransaction.State state;
    private long beginTimeMillis = -1L;
    private long limitTimeMillis = -1L;
    private long timeoutMillis = -1L;
    private Map<String, QueryConnection> connectionMap = new LinkedHashMap<String, QueryConnection>();
    private final Map<String, QueryConnectionFactory> connectionFactoryMap = new HashMap<String, QueryConnectionFactory>();
    private final QueryResultList resultLst = this.newQueryResultList();

    protected DefaultQueryTransaction() {
        this.state = QueryTransaction.State.Created;
    }

    protected QueryResultList newQueryResultList() {
        return new QueryResultList();
    }

    @Override
    public void begin() {
        this.begin(this.timeoutMillis);
    }

    @Override
    public void begin(long l) {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.Created}, QueryTransaction.State.Begining);
        this.beginTimeMillis = System.currentTimeMillis();
        this.limitTimeMillis = l >= 0L ? this.beginTimeMillis + l : -1L;
        this.state = QueryTransaction.State.Begined;
    }

    @Override
    public void commit() {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.Begined, QueryTransaction.State.Committed, QueryTransaction.State.Rollbacked}, QueryTransaction.State.Committing);
        for (QueryConnection queryConnection : this.connectionMap.values()) {
            queryConnection.commit();
        }
        this.state = QueryTransaction.State.Committed;
    }

    @Override
    public void rollback() {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.Begined, QueryTransaction.State.Committing, QueryTransaction.State.Committed, QueryTransaction.State.Rollbacked}, QueryTransaction.State.Rollbacking);
        for (QueryConnection queryConnection : this.connectionMap.values()) {
            queryConnection.rollback();
        }
        this.state = QueryTransaction.State.Rollbacked;
    }

    @Override
    public void end() {
        QueryTransaction.State state = this.state;
        this.state = QueryTransaction.State.Ending;
        Map<String, QueryConnection> map = this.connectionMap;
        this.connectionMap = new LinkedHashMap<String, QueryConnection>();
        if (state != QueryTransaction.State.Created && state != QueryTransaction.State.Committed && state != QueryTransaction.State.Rollbacked) {
            for (QueryConnection queryConnection : map.values()) {
                queryConnection.rollback();
            }
        }
        for (QueryConnection queryConnection : map.values()) {
            queryConnection.close();
        }
        this.state = QueryTransaction.State.Ended;
    }

    @Override
    public QueryTransaction.State getState() {
        return this.state;
    }

    protected long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long l) {
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.Created});
        this.timeoutMillis = l;
    }

    @Override
    public long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    @Override
    public long getLimitTimeMillis() {
        return this.limitTimeMillis;
    }

    protected final void changeState(QueryTransaction.State[] stateArray, QueryTransaction.State state) {
        this.checkState(stateArray);
        this.state = state;
    }

    protected final void checkState(QueryTransaction.State[] stateArray) {
        for (QueryTransaction.State state : stateArray) {
            if (state != this.state) continue;
            return;
        }
        throw new ReasonedRuntimeException((Enum)QueryTransaction.Error.IllegalState, this.state.name());
    }

    @Override
    public QueryConnection getConnection(String string) throws ReasonedException {
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.Begined});
        QueryConnection queryConnection = this.connectionMap.get(string);
        if (queryConnection == null) {
            QueryConnectionFactory queryConnectionFactory = this.connectionFactoryMap.get(string);
            if (queryConnectionFactory == null) {
                throw new ReasonedException((Enum)QueryTransaction.Error.ConnectionNotFound, string);
            }
            queryConnection = queryConnectionFactory.create(string, this);
            queryConnection.open();
            this.connectionMap.put(string, queryConnection);
        }
        return queryConnection;
    }

    @Override
    public void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
        assert (string != null && queryConnectionFactory != null) : string == null ? "@param:connId is null." : "@param:factory is null.";
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.Created});
        this.connectionFactoryMap.put(string, queryConnectionFactory);
    }

    @Override
    public QueryResultList getQueryResultList() {
        return this.resultLst;
    }
}

