/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ts.tester.function.FunctionTester;

public class ObjectInspector {
    private HashMap<String, Object> expectedMap_ = new HashMap();
    private HashSet<String> ignoredFieldSet_ = new HashSet();
    private FunctionTester tester_;

    public ObjectInspector(FunctionTester functionTester) {
        assert (functionTester != null) : "@param:tester is null.";
        this.tester_ = functionTester;
    }

    public void expect(String string, Object object) {
        assert (string != null) : "@param:fieldName is null.";
        this.expectedMap_.put(string, object);
    }

    public Object getExpected(String string) throws NoSuchFieldException {
        assert (string != null) : "@param:fieldName is null.";
        if (!this.expectedMap_.containsKey(string)) {
            throw new NoSuchFieldException(string);
        }
        return this.expectedMap_.get(string);
    }

    public void expect(String string, boolean bl) {
        this.expect(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void expect(String string, byte by) {
        this.expect(string, new Byte(by));
    }

    public void expect(String string, char c) {
        this.expect(string, new Character(c));
    }

    public void expect(String string, short s) {
        this.expect(string, new Short(s));
    }

    public void expect(String string, int n) {
        this.expect(string, new Integer(n));
    }

    public void expect(String string, long l) {
        this.expect(string, new Long(l));
    }

    public void expect(String string, float f) {
        this.expect(string, new Float(f));
    }

    public void expect(String string, double d) {
        this.expect(string, new Double(d));
    }

    public void ignore(String string) {
        assert (string != null) : "@param:fieldName is null.";
        this.ignoredFieldSet_.add(string);
    }

    /*
     * Loose catch block
     */
    protected Field findField(Class clazz, String string) throws NoSuchFieldException {
        assert (clazz != null) : "@param;clazz is null.";
        assert (string != null) : "@param:fieldName is null.";
        Class clazz2 = clazz;
        while (true) {
            try {
                return clazz2.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz2 = clazz2.getSuperclass();
                if (clazz2 == null) continue;
                continue;
            }
            break;
        }
        catch (Exception exception) {
            throw new NoSuchFieldException(string);
        }
    }

    public boolean isInheritance(Class clazz, Class clazz2) {
        assert (clazz != null) : "@param:clazz is null.";
        assert (clazz2 != null) : "@param:superClass is null.";
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!this.isInheritance(classArray[i], clazz2)) continue;
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return this.isInheritance(clazz3, clazz2);
    }

    public void inspect(Object object, String string) throws NoSuchFieldException {
        assert (object != null) : "@param:obj is null.";
        assert (string != null) : "@param:fieldName is null.";
        Object object2 = null;
        Object object3 = null;
        Field field = null;
        try {
            object2 = this.getExpected(string);
            field = this.findField(object.getClass(), string);
            field.setAccessible(true);
            object3 = field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw noSuchFieldException;
        }
        catch (Exception exception) {
            this.tester_.NG(exception);
        }
        this.inspect(field, object3, object2);
    }

    public void inspect(Object object) {
        assert (object != null) : "@param:obj is null.";
        HashSet<String> hashSet = new HashSet<String>();
        Class<?> clazz = object.getClass();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string;
                if (fieldArray[i].isSynthetic() || hashSet.contains(string = fieldArray[i].getName())) continue;
                hashSet.add(string);
                Object object2 = null;
                try {
                    object2 = this.getExpected(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (this.ignoredFieldSet_.contains(string)) continue;
                    this.tester_.NG(noSuchFieldException);
                    continue;
                }
                catch (Exception exception) {
                    this.tester_.NG(exception);
                    continue;
                }
                Object object3 = null;
                try {
                    fieldArray[i].setAccessible(true);
                    object3 = fieldArray[i].get(object);
                }
                catch (Exception exception) {
                    this.tester_.NG(exception);
                    continue;
                }
                this.inspect(fieldArray[i], object3, object2);
            }
        } while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class));
    }

    private void inspect(Field field, Object object, Object object2) {
        if (object2 == null || object == null) {
            this.tester_.EQUAL(object, object2);
        } else if (field.getType().isArray()) {
            if (object instanceof boolean[]) {
                this.tester_.EQUAL((boolean[])object, (boolean[])object2);
            } else if (object instanceof byte[]) {
                this.tester_.EQUAL((byte[])object, (byte[])object2);
            } else if (object instanceof char[]) {
                this.tester_.EQUAL((char[])object, (char[])object2);
            } else if (object instanceof short[]) {
                this.tester_.EQUAL((short[])object, (short[])object2);
            } else if (object instanceof int[]) {
                this.tester_.EQUAL((int[])object, (int[])object2);
            } else if (object instanceof long[]) {
                this.tester_.EQUAL((long[])object, (long[])object2);
            } else if (object instanceof float[]) {
                this.tester_.EQUAL((float[])object, (float[])object2);
            } else if (object instanceof double[]) {
                this.tester_.EQUAL((double[])object, (double[])object2);
            } else {
                this.tester_.EQUAL((Object[])object, (Object[])object2);
            }
        } else if (this.isInheritance(field.getType(), List.class)) {
            this.tester_.EQUAL((Object)((List)object), (Object)((List)object2));
        } else if (this.isInheritance(field.getType(), Collection.class)) {
            this.tester_.EQUAL((Object)((Collection)object), (Object)((Collection)object2));
        } else if (this.isInheritance(field.getType(), Map.class)) {
            this.tester_.EQUAL((Object)((Map)object), (Object)((Map)object2));
        } else if (object instanceof StringBuffer) {
            this.tester_.MATCH((StringBuffer)object, (StringBuffer)object2);
        } else {
            this.tester_.EQUAL(object, object2);
        }
    }

    public Object invokeMethod(Object object, String string) throws NoSuchMethodException, Exception {
        return this.invokeMethod(object, string, new Class[0], new Object[0]);
    }

    public Object invokeMethod(Object object, String string, Class clazz, Object object2) throws NoSuchMethodException, Exception {
        Class[] classArray = new Class[]{clazz};
        return this.invokeMethod(object, string, classArray, object2);
    }

    public Object invokeMethod(Object object, String string, Class[] classArray, Object ... objectArray) throws NoSuchMethodException, Exception {
        assert (object != null) : "@param;obj is null.";
        assert (string != null) : "@param:methodName is null.";
        assert (classArray != null) : "@param;argTypes is null.";
        assert (objectArray != null) : "@param;argValues is null.";
        assert (classArray.length == objectArray.length) : "Both numbers of @param:argTypes and @param:argValues are different.";
        assert (!Arrays.asList(classArray).contains(null)) : "@param:argTypes has null elements.";
        Class<?> clazz = object.getClass();
        Method method = null;
        while (true) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) continue;
            }
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        try {
            Class<Void> clazz2 = method.invoke(object, objectArray);
            if (method.getReturnType().equals(Void.TYPE)) {
                clazz2 = Void.TYPE;
            }
            return clazz2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw invocationTargetException;
        }
    }

    public Object invokeMethod(Object object, String string, List<Class> list, Object ... objectArray) throws NoSuchMethodException, Exception {
        assert (list != null) : "@param:argTypes is null.";
        Class[] classArray = list.toArray(new Class[list.size()]);
        return this.invokeMethod(object, string, classArray, objectArray);
    }
}

