/*
 * AbstractResource class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import ts.util.text.StringOperation;
import ts.util.text.StringSequence;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

/**
 * \[XNX̒ۃNXB
 * <br>
 * \[XNXɋʂ̎`B
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:48 $
 */
public abstract class AbstractResource implements Resource
{
  /** L[̗vf̋؂蕶B */
  private String elementSeparator_ = ".";

  /** L[̑͂ޕ̔zB */
  private String[] attributeParenthesis_ = { "(", ")" };

  /** L[̑̋؂蕶B */
  private String attributeSeparator_ = ",";

  /** L[̖̑Oƒlѕt镶B */
  private String attributeMatchMark_ = "=";

  /** \[Xt@CpXB */
  private String path_ = null;

  /**
   * ftHgRXgN^B
   */
  public AbstractResource()
  {}

  /**
   * Rs[RXgN^B
   *
   * @param  res Rs[̃\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public AbstractResource(AbstractResource res)
  {
    assert (res != null) : "@param:res is null.";

    setElementSeparator(res.elementSeparator());
    setAttributeSeparator(res.attributeSeparator());
    setAttributeMatchMark(res.attributeMatchMark());

    String[] par = res.attributeParenthesis();
    setAttributeParenthesis(par[0], par[1]);

    path_ = res.path_;
  }

  /**
   * L[̗vf̋؂蕶ݒ肷B
   *
   * @param  separator L[̗vf̋؂蕶B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #setElementSeparator(String)}gpĉB
   */
  @Deprecated
  protected void setElementSeparator(char separator)
  {
    elementSeparator_ = String.valueOf(separator);
  }

  /**
   * L[̗vf̋؂蕶ݒ肷B
   * <br>
   * ̕񂪂PłȂꍇ͗OX[B
   *
   * @param  separator L[̗vf̋؂蕶B
   * @throws IllegalArgumentException ̕񂪂PłȂꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁j
   */
  protected void setElementSeparator(String separator)
  {
    assert (separator != null) : "@param:separator is null.";

    if (StringOperation.length(separator) != 1) {
      throw new IllegalArgumentException(
        "@param:separator is not a charactor.");
    }

    elementSeparator_ = separator;
  }

  /**
   * L[̗vf̋؂蕶擾B
   *
   * @return L[̗vf̋؂蕶B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #elementSeparator()}gpĉB
   */
  @Deprecated
  public char getElementSeparator()
  {
    return elementSeparator_.charAt(0) ;
  }

  /**
   * L[̗vf̋؂蕶擾B
   *
   * @return L[̗vf̋؂蕶B
   */
  public String elementSeparator()
  {
    return elementSeparator_ ;
  }

  /**
   * L[̑͂ޕݒ肷B
   *
   * @param  openPar L[̑͂ފJʁB
   * @param  closePar L[̑͂ޕʁB
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #setAttributeParenthesis(String,String)}gpĉB
   */
  @Deprecated
  protected void setAttributeParenthesis(char openPar, char closePar)
  {
    attributeParenthesis_[0] = String.valueOf(openPar);
    attributeParenthesis_[1] = String.valueOf(closePar);
  }

  /**
   * L[̑͂ޕݒ肷B
   * <br>
   * ̕񂪂PłȂꍇ͗OX[B
   *
   * @param  openPar L[̑͂ފJʁB
   * @param  closePar L[̑͂ޕʁB
   * @throws IllegalArgumentException ̕񂪂PłȂꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁j
   */
  protected void setAttributeParenthesis(String openPar, String closePar)
  {
    assert (openPar != null) : "@param:openPar is null.";
    assert (closePar != null) : "@param:closePar is null.";

    if (StringOperation.length(openPar) != 1) {
      throw new IllegalArgumentException(
        "@param:openPar is not a charactor.");
    }

    if (StringOperation.length(closePar) != 1) {
      throw new IllegalArgumentException(
        "@param:closePar is not a charactor.");
    }

    attributeParenthesis_[0] = openPar;
    attributeParenthesis_[1] = closePar;
  }

  /**
   * L[̑͂ޕ擾B
   *
   * @return L[̑͂ޕ̔zB
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #attributeParenthesis()}gpĉB
   */
  @Deprecated
  public char[] getAttributeParenthesis()
  {
    char[] arr = new char[2];
    arr[0] = attributeParenthesis_[0].charAt(0);
    arr[1] = attributeParenthesis_[1].charAt(0);
    return arr;
  }

  /**
   * L[̑͂ޕ擾B
   *
   * @return L[̑͂ޕ̔zB
   */
  public String[] attributeParenthesis()
  {
    return attributeParenthesis_ ;
  }

  /**
   * L[̑̋؂蕶ݒ肷B
   *
   * @param  separator L[̑̋؂蕶B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #setAttributeSeparator(char)}gpĉB
   */
  @Deprecated
  protected void setAttributeSeparator(char separator)
  {
    attributeSeparator_ = String.valueOf(separator);
  }

  /**
   * L[̑̋؂蕶ݒ肷B
   * <br>
   * ̕񂪂PłȂꍇ͗OX[B
   *
   * @param  separator L[̑̋؂蕶B
   * @throws IllegalArgumentException ̕񂪂PłȂꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁j
   */
  protected void setAttributeSeparator(String separator)
  {
    assert (separator != null) : "@param:separator is null.";

    if (StringOperation.length(separator) != 1) {
      throw new IllegalArgumentException(
        "@param:separator is not a charactor.");
    }

    attributeSeparator_ = separator;
  }

  /**
   * L[̑̋؂蕶擾B
   *
   * @return L[̑̋؂蕶B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #attributeSeparator()}gpĉB
   */
  @Deprecated
  public char getAttributeSeparator()
  {
    return attributeSeparator_.charAt(0) ;
  }

  /**
   * L[̑̋؂蕶擾B
   *
   * @return L[̑̋؂蕶B
   */
  public String attributeSeparator()
  {
    return attributeSeparator_ ;
  }

  /**
   * L[̖̑Oƒlѕt镶ݒ肷B
   *
   * @param  mark L[̖̑Oƒlѕt镶B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #setAttributeMatchMark(String)}gpĉB
   */
  @Deprecated
  protected void setAttributeMatchMark(char mark)
  {
    attributeMatchMark_ = String.valueOf(mark);
  }

  /**
   * L[̖̑Oƒlѕt镶ݒ肷B
   * <br>
   * ̕񂪂PłȂꍇ͗OX[B
   *
   * @param  mark L[̖̑Oƒlѕt镶B
   * @throws IllegalArgumentException ̕񂪂PłȂꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁j
   */
  protected void setAttributeMatchMark(String mark)
  {
    assert (mark != null) : "@param:mark is null.";

    if (StringOperation.length(mark) != 1) {
      throw new IllegalArgumentException(
        "@param:mark is not a charactor.");
    }

    attributeMatchMark_ = mark;
  }

  /**
   * L[̖̑Oƒlѕt镶擾B
   *
   * @return L[̖̑Oƒlѕt镶擾B
   * @deprecated <char>char</code>ϐ̎gp邽ߔp~B{@link
   *   #attributeMatchMark()}gpĉB
   */
  @Deprecated
  public char getAttributeMatchMark()
  {
    return attributeMatchMark_.charAt(0) ;
  }

  /**
   * L[̖̑Oƒlѕt镶擾B
   *
   * @return L[̖̑Oƒlѕt镶擾B
   */
  public String attributeMatchMark()
  {
    return attributeMatchMark_ ;
  }

  /**
   * w肳ꂽL[vf̗vf擾B
   * <br>
   * {@link #splitKey(String) splitKey}\bhɂĕꂽL[vf
   * vfoB
   *
   * @param  keyElem L[vfB
   * @return vfB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String getNameOfKeyElement(String keyElem)
  {
    assert (keyElem != null) : "@param:keyElem is null.";

    int index = StringOperation.indexOf(keyElem, attributeParenthesis()[0]);
    return (index < 0) ? keyElem : StringOperation.substring(keyElem, 0, index);
  }

  /**
   * w肳ꂽL[vf̖̑Oƒl̑g񋓂B
   * <br>
   * {@link #splitKey(String) splitKey}\bhɂĕꂽL[vf
   * oA̖Oƒl̔z񋓃IuWFNgɊi[ĕԂB
   *
   * @param  keyElem L[vfB
   * @return ̖Oƒl̔zi[񋓃IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected List<String[]> listAttributesOfKeyElement(String keyElem)
  {
    assert (keyElem != null) : "@param:keyElem is null";

    final int openParLen = StringOperation.length(attributeParenthesis()[0]);
    final int closeParLen = StringOperation.length(attributeParenthesis()[1]);
    final int attrSepLen = StringOperation.length(attributeSeparator());
    final int matchMarkLen = StringOperation.length(attributeMatchMark());

    List<String[]> attrLst = new ArrayList<String[]>();

    StringSequence seq = new StringSequence(keyElem);
    if (! seq.nextUntil(attributeParenthesis()[0]).validIndex()) {
      return attrLst;
    }

    StringSequence bgn = seq.copy();
    String[] attr = new String[2];
    for ( ; seq.validIndex(); seq.next()) {
      if (attr[0] == null && seq.startsWith(attributeMatchMark())) { 
        attr[0] = bgn.followingString(seq);
        seq.next(matchMarkLen - 1);
        bgn = seq.copy();
      }
      else if (seq.startsWith(attributeSeparator())) {
        attr[1] = bgn.followingString(seq);
        attrLst.add(attr);
        attr = new String[2];
        seq.next(attrSepLen - 1);
        bgn = seq.copy();
      }
      else if (seq.startsWith(attributeParenthesis()[1])) {
        break;
      }
    }

    attr[1] = bgn.followingString(seq);
    attrLst.add(attr);
    return attrLst;
  }

  /**
   * L[vfƂɕB
   * <br>
   * ۂɃL[̏̌؂sAȉɔꍇɗOX[B
   * <ul>
   * <li>L[󕶎łLƂivf\j</li>
   * <li>vf́A̕ʂŏIĂȂ΂ȂȂ</li>
   * <li>̊ʂJ܂܁AvfIĂ͂ȂȂ</li>
   * <li>̗vf͋Ȃ</li>
   * <li>̑͋Ȃ</li>
   * <li>̑̒ɖOƒl݂̓Ȃ΂ȂȂB
   *     ݂Ȃꍇ͍ŏ̓̂ݗLƂAԖڈȍ~͒l̈ꕔƂ
   *     ߂B</li>
   * </ul>
   *
   * @param  key L[B
   * @throws IllegalKeyException L[sȏꍇB
   */
  protected List<String> splitKey(String key) throws IllegalKeyException
  {
    assert (key != null) : "@param:key is null.";

    final int elemSepLen = StringOperation.length(elementSeparator());
    final int attrSepLen = StringOperation.length(attributeSeparator());
    final int openParLen = StringOperation.length(attributeParenthesis()[0]);
    final int closeParLen = StringOperation.length(attributeParenthesis()[1]);
    final int matchMarkLen = StringOperation.length(attributeMatchMark());

    List<String> lst = new ArrayList<String>();
    if (StringOperation.isEmpty(key)) {
      return lst;
    }

    StringSequence seq = new StringSequence(key, -1);
    StringSequence elemBgn = seq.copy();
    L0:for (seq.next(); seq.validIndex(); seq.next()) {
      if (seq.startsWith(elementSeparator())) {

        String elemName = elemBgn.followingString(seq);
        if (StringOperation.isEmpty(elemName)) {
          throw new ElementNameEmptyException(key);
        }
        lst.add(elemName);
        seq.next(elemSepLen - 1);
        elemBgn = seq.copy();
      }
      else if (seq.startsWith(attributeParenthesis()[0])) {

        String elemName = elemBgn.followingString(seq);
        if (StringOperation.isEmpty(elemName)) {
          throw new ElementNameEmptyException(key);
        }
        seq.next(openParLen - 1);

        StringSequence attrBgn = seq.copy();
        boolean existMatchMark = false;
        for ( ; seq.validIndex(); seq.next()) {
          if (!existMatchMark && seq.startsWith(attributeMatchMark())) {

            String attrName = attrBgn.followingString(seq);
            if (StringOperation.isEmpty(attrName)) {
              throw new AttributeNameEmptyException(key);
            }
            existMatchMark = true;
            seq.next(matchMarkLen - 1);
          }
          else if (seq.startsWith(attributeSeparator())) {
            if (! existMatchMark) {
              throw new AttributeNoMatchMarkException(key);
            }
            existMatchMark = false;
            seq.next(attrSepLen - 1);
            attrBgn = seq.copy();
          }
          else if (seq.startsWith(attributeParenthesis()[1])) {
            if (! existMatchMark) {
              throw new AttributeNoMatchMarkException(key);
            }
            existMatchMark = false;
            if (! seq.next(closeParLen).validIndex()) {
              break L0;
            }

            String elem = elemBgn.followingString(seq);
            lst.add(elem);
            if (! seq.startsWith(elementSeparator())) {
              throw new ElementBadEndCharException(key);
            }
            elemBgn = seq.copy();
            continue L0;
          }
        }
        throw new AttributeNoCloseParException(key);
      }
    }

    String elemLast = elemBgn.followingString(seq);
    if (StringOperation.isEmpty(elemLast)) {
      throw new ElementNameEmptyException(key);
    }
    lst.add(elemLast);

    return lst;
  }

  /**
   * [h\[Xt@C̃pX擾B
   * <br>
   * ܂x\[Xt@C̓ǂݍ݂sĂȂꍇ́A󕶎ԂB
   *
   * @return [h\[Xt@C̃pXB
   */
  public String getPath()
  {
    return path_ ;
  }

  /**
   * w肳ꂽpX̃\[Xt@CǂݍށB
   *
   * @param  path \[Xt@C̃pXB
   * @throws FileNotFoundException w肳ꂽpX̃t@CȂ
   *          ꍇB
   * @throws IOException t@C̓ǂݍݒɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void load(String path)
    throws FileNotFoundException, IOException
  {
    assert (path != null) : "@param:path is null.";

    InputStream in = null;
    try {
      in = getInputStream(path);
      load(in);
      path_ = path;
    }
    finally {
      if (in != null) in.close();
    }
  }

  /**
   * w肳ꂽpX̓Xg[擾B
   *
   * @param  path \[Xt@C̃pXB
   * @return ̃pXɑ΂̓Xg[B 
   * @throws FileNotFoundException w肳ꂽpX̃t@CȂ
   *          ꍇB
   * @throws IOException ̓Xg[̃I[vɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected InputStream getInputStream(String path)
    throws FileNotFoundException, IOException
  {
    assert (path != null) : "@param:path is null.";

    return new FileInputStream(path);
  }

  /**
   * ̓̓Xg[烊\[Xt@C̓eǂݍށB
   *
   * @param  stream ̓Xg[B
   * @throws IOException ǂݍݒɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected abstract void load(InputStream stream) throws IOException;

  /**
   * w肳ꂽpX̃t@CɁÃIuWFNgێĂeۑB
   *
   * @param  path ۑ̃t@C̃pXB
   * @throws IOException t@C̕ۑɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void save(String path) throws IOException
  {
    assert (path != null) : "@param:path is null.";

    OutputStream out = null;
    try {
      out = getOutputStream(path);
      save(out);
    } 
    finally {
      if (out != null) out.close();
    }
  }

  /**
   * w肳ꂽpX̏o̓Xg[擾B
   *
   * @param  path ۑ̃t@C̃pXB
   * @return ̃pXɑ΂o̓Xg[B
   * @throws IOException w肳ꂽpX̃I[vɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected OutputStream getOutputStream(String path) throws IOException
  {
    assert (path != null) : "@param:path is null.";

    return new FileOutputStream(path);
  }

  /**
   * ̏o̓Xg[ɁÃIuWFNgێĂeۑB
   *
   * @param  stream ۑ̏o̓Xg[B
   * @throws IOException t@C̕ۑɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected abstract void save(OutputStream stream)
    throws IOException;
}
