/*
 * Quad class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.io.Serializable;

/**
 * l̃IuWFNg̑gێNXB
 * <p>
 * l̃IuWFNg̑gtB[hϐƂĕێA
 * ꂼ̑g̐ݒ擾s\bhAyъeIuWFNg̒l
 * rɂ悤l̔s\bhpӂĂB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class Quad<F,S,T,O> implements Serializable
{
  /* VAԍB */
  static final long serialVersionUID = 8340877329259337297L;

  /** 1IuWFNgB */
  private F value1_ ;

  /** 2IuWFNgB */
  private S value2_ ;

  /** 3IuWFNgB */
  private T value3_ ;

  /** 4IuWFNgB */
  private O value4_ ;

  /**
   * ftHgRXgN^B
   */
  public Quad()
  {}

  /**
   * l̃IuWFNgɂƂRXgN^B
   * <br>
   * k̏ꍇ͂̂܂܃kݒ肷B
   *
   * @param  first  IuWFNgB
   * @param  second IuWFNgB
   * @param  third  OIuWFNgB 
   * @param  fourth lIuWFNgB
   */
  public Quad(F first, S second, T third, O fourth)
  {
    set(first, second, third, fourth);
  }

  /**
   * l̃IuWFNgݒ肷B
   * <br>
   * k̏ꍇ͂̂܂܃kݒ肷B
   *
   * @param  first  IuWFNgB
   * @param  second IuWFNgB
   * @param  third  OIuWFNgB 
   * @param  fourth lIuWFNgB
   */
  public void set(F first, S second, T third, O fourth)
  {
    setFirst(first);
    setSecond(second);
    setThird(third);
    setFourth(fourth);
  }

  /**
   * IuWFNgݒ肷B
   * <br>
   * k̏ꍇ͂̂܂܃kݒ肷B
   *
   * @param  first IuWFNgB
   */
  public void setFirst(F first)
  {
    value1_ = first;
  }

  /**
   * IuWFNg擾B
   *
   * @return IuWFNgB
   */
  public F getFirst()
  {
    return value1_;
  }

  /**
   * IuWFNgݒ肷B
   * <br>
   * k̏ꍇ͂̂܂܃kݒ肷B
   *
   * @param  second IuWFNgB
   */
  public void setSecond(S second)
  {
    value2_ = second;
  }

  /**
   * IuWFNg擾B
   *
   * @return IuWFNgB
   */
  public S getSecond()
  {
    return value2_;
  }

  /**
   * OIuWFNgݒ肷B
   * <br>
   * Ƀkݒ肵ꍇ͂̂܂܃kݒ肷B
   *
   * @param  third OIuWFNgB
   */
  public void setThird(T third)
  {
    value3_ = third;
  }

  /**
   * OIuWFNg擾B
   *
   * @return OIuWFNgB
   */
  public T getThird()
  {
    return value3_ ;
  }

  /**
   * lIuWFNgݒ肷B
   * <br>
   * k̏ꍇ͂̂܂܃kݒ肷B
   *
   * @param  fourth lIuWFNgB
   */
  public void setFourth(O fourth)
  {
    value4_ = fourth;
  }

  /**
   * lIuWFNg擾B
   *
   * @return lIuWFNgB
   */
  public O getFourth()
  {
    return value4_;
  }

  /**
   * w肳ꂽIuWFNgƓeǂrB
   * <br>
   * <code>Quad</code>IuWFNg̏ꍇ́ÃtB[hϐ
   * l̃IuWFNgꂼrāASēꍇ<tt>true</tt>
   * AłȂ<tt>false</tt>ԂB
   * k܂<code>Quad</code>IuWFNgłȂꍇ<tt>false</tt>
   * ԂB
   *
   * @param  obj rIuWFNgB
   * @return IuWFNg̓eꍇ<tt>true</tt>ԂB
   */
  public boolean equals(Object obj)
  {
    if (obj == null || !(obj instanceof Quad))
      return false;

    Quad another = Quad.class.cast(obj);

    if (getFirst() == null) {
      if (another.getFirst() != null)
        return false;
    }
    else if (! getFirst().equals(another.getFirst())) {
      return false;
    }

    if (getSecond() == null) {
      if (another.getSecond() != null)
        return false;
    }
    else if (! getSecond().equals(another.getSecond())) {
      return false;
    }

    if (getThird() == null) {
      if (another.getThird() != null)
        return false;
    }
    else if (! getThird().equals(another.getThird())) {
      return false;
    }

    if (getFourth() == null) {
      if (another.getFourth() != null)
        return false;
    }
    else if (! getFourth().equals(another.getFourth())) {
      return false;
    }

    return true;
  }

  /**
   * nbVR[h擾B
   *
   * @return  nbVR[hB
   */
  public int hashCode()
  {
    int v1 = (getFirst () == null) ? 0 : getFirst ().hashCode();
    int v2 = (getSecond() == null) ? 0 : getSecond().hashCode();
    int v3 = (getThird () == null) ? 0 : getThird ().hashCode();
    int v4 = (getFourth() == null) ? 0 : getFourth().hashCode();
    return (v1 + v2 + v3 + v4);
  }
}
