/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import ts.tester.coverage.Result;

public class PassResult<K>
extends Result<K> {
    private Map<K, PassCounter> passMap_ = new TreeMap<K, PassCounter>();
    private int passedResultCount_ = 0;

    @Override
    public void addResult(K k) {
        assert (k != null) : "@param:resultKey is null.";
        if (this.passMap_.containsKey(k)) {
            return;
        }
        this.passMap_.put(k, new PassCounter());
    }

    @Override
    public int countAllResults() {
        return this.passMap_.size();
    }

    @Override
    public int countPassedResults() {
        return this.passedResultCount_;
    }

    @Override
    public void incrementPassCountOfResult(K k) {
        assert (k != null) : "@param:resultKey is null.";
        PassCounter passCounter = this.passMap_.get(k);
        if (passCounter == null) {
            return;
        }
        if (passCounter.countPassed() == 0) {
            ++this.passedResultCount_;
        }
        passCounter.incrementPassCount();
    }

    @Override
    public boolean containsKeyOfResult(K k) {
        assert (k != null) : "@param:resultKey is null.";
        return this.passMap_.containsKey(k);
    }

    @Override
    public int getPassCountOfResult(K k) {
        assert (k != null) : "@param:resultKey is null.";
        PassCounter passCounter = this.passMap_.get(k);
        return passCounter != null ? passCounter.countPassed() : 0;
    }

    @Override
    public Enumeration<K> enumAllResultKeys() {
        return Collections.enumeration(this.passMap_.keySet());
    }

    @Override
    public Enumeration<K> enumPassedResultKeys() {
        ArrayList<K> arrayList = new ArrayList<K>(this.passMap_.size());
        for (Map.Entry<K, PassCounter> entry : this.passMap_.entrySet()) {
            if (entry.getValue().countPassed() <= 0) continue;
            arrayList.add(entry.getKey());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public Enumeration<K> enumNotPassedResultKeys() {
        ArrayList<K> arrayList = new ArrayList<K>(this.passMap_.size());
        for (Map.Entry<K, PassCounter> entry : this.passMap_.entrySet()) {
            if (entry.getValue().countPassed() > 0) continue;
            arrayList.add(entry.getKey());
        }
        return Collections.enumeration(arrayList);
    }

    private class PassCounter {
        private int passCount_ = 0;

        private PassCounter() {
        }

        int countPassed() {
            return this.passCount_;
        }

        void incrementPassCount() {
            ++this.passCount_;
        }
    }
}

