/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ts.util.text.StringCutter;
import ts.util.text.StringOperation;

public class FilePathPatternFilter
implements FileFilter {
    private String basePath_;
    private List<List<List<String>>> pathPatternLLL_;

    public FilePathPatternFilter(File file, String string) throws IllegalArgumentException {
        assert (file != null) : "@param:baseDir is null.";
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("@param:baseDir is not directory.");
        }
        try {
            this.basePath_ = file.getCanonicalPath();
            if (!StringOperation.endsWith(this.basePath_, File.separator)) {
                this.basePath_ = this.basePath_ + File.separator;
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException);
            illegalArgumentException.setStackTrace(iOException.getStackTrace());
            throw illegalArgumentException;
        }
        this.pathPatternLLL_ = this.parsePathPattern(string);
    }

    private List<List<List<String>>> parsePathPattern(String string) throws IllegalArgumentException {
        assert (string != null) : "@param:pathPattern is null.";
        if (StringOperation.startsWith(string, "/")) {
            throw new IllegalArgumentException("@param:pathPattern must not start with '/', because it is relative path.");
        }
        List<String> list = StringCutter.split(string, "/");
        return this.splitWithAsterisk(list);
    }

    private List<List<List<String>>> splitWithAsterisk(List<String> list) {
        LinkedList<List<List<String>>> linkedList = new LinkedList<List<List<String>>>();
        LinkedList<List<String>> linkedList2 = new LinkedList<List<String>>();
        linkedList.add(linkedList2);
        boolean bl = false;
        for (String string : list) {
            if (StringOperation.isEmpty(string)) {
                throw new IllegalArgumentException("Specified path pattern includes empty path elements.");
            }
            if (StringOperation.contains(string, "**")) {
                if (string.equals("**")) {
                    linkedList2 = new LinkedList();
                    linkedList.add(linkedList2);
                    continue;
                }
                throw new IllegalArgumentException("Wild card '**' cannot be used for a file name.");
            }
            linkedList2.add(StringCutter.split(string, "*"));
        }
        return linkedList;
    }

    @Override
    public boolean accept(File file) {
        assert (file != null) : "@param:file is null.";
        try {
            String string = file.getCanonicalPath();
            if (!StringOperation.startsWith(string, this.basePath_)) {
                return false;
            }
            int n = StringOperation.length(this.basePath_);
            String string2 = StringOperation.substring(string, n);
            string2 = string2.replace(File.separator, "/");
            return this.matchPattern(string2, this.pathPatternLLL_);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean matchPattern(String string, List<List<List<String>>> list) {
        List<String> list2 = StringCutter.split(string, "/");
        Iterator<List<List<String>>> iterator = list.iterator();
        if (iterator.hasNext()) {
            List<List<String>> list3 = iterator.next();
            if (!this.matchPatternElement(list2, 0, list3)) {
                return false;
            }
            int n = list3.size();
            block0: while (iterator.hasNext()) {
                list3 = iterator.next();
                if (list3.size() == 0) continue;
                while (n < list2.size()) {
                    if (this.matchPatternElement(list2, n, list3)) {
                        n += list3.size();
                        continue block0;
                    }
                    ++n;
                }
                return false;
            }
            return n >= list2.size() || list3.size() == 0;
        }
        return false;
    }

    private boolean matchPatternElement(List<String> list, int n, List<List<String>> list2) {
        if (list2.size() + n > list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string = list.get(i + n);
            List<String> list3 = list2.get(i);
            Iterator<String> iterator = list3.iterator();
            if (!iterator.hasNext()) {
                return StringOperation.isEmpty(string);
            }
            int n2 = 0;
            String string2 = iterator.next();
            if (!StringOperation.isEmpty(string2)) {
                if (!StringOperation.startsWith(string, string2)) {
                    return false;
                }
                n2 = StringOperation.length(string2);
            } else if (!iterator.hasNext()) {
                return false;
            }
            while (iterator.hasNext()) {
                string2 = iterator.next();
                n2 = StringOperation.indexOf(string, string2, n2);
                if (n2 < 0) {
                    return false;
                }
                n2 += StringOperation.length(string2);
            }
            if (StringOperation.isEmpty(string2) || n2 == StringOperation.length(string)) continue;
            return false;
        }
        return true;
    }
}

