package ts.graph;

import ts.tester.function.coverage.FunctionTester;
import java.awt.*;
import java.awt.font.*;
import java.util.*;

public class TextStyleTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(TextStyleTest.class, (args.length > 0) ? args[0] : null);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test cases -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    TextStyle tstyle = new TextStyle();
    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 0);
  }

  public void constructor_color()
  {
    MSG("FɂƂRXgN^B");

    TextStyle tstyle = new TextStyle(Color.red);
    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.red);
  }

  public void constructor_color_size()
  {
    MSG("FƃTCYɂƂRXgN^B");

    TextStyle tstyle = new TextStyle(Color.blue, 10);
    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 2);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.blue);
    EQUAL(map.get(TextAttribute.SIZE), 10.0f);

    tstyle = new TextStyle(Color.black, -1);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 2);
    EQUAL(map.get(TextAttribute.SIZE), 0.0f);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.black);
  }

  public void constructor_fontfamily_size()
  {
    MSG("tHgƃTCYɂƂRXgN^B");

    TextStyle tstyle = new TextStyle(Color.blue, "lr SVbN", 10);
    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 3.0f);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.blue);
    EQUAL(map.get(TextAttribute.FAMILY), "lr SVbN");
    EQUAL(map.get(TextAttribute.SIZE), 10.0f);
  }

  public void constructor_size_bold_italic()
  {
    MSG("TCYA{[ĥɂ邩AC^bN̂ɂ邩ɂƂRXgN^B");

    TextStyle tstyle = new TextStyle(Color.blue, 10, true, true);
    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 4f);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.blue);
    EQUAL(map.get(TextAttribute.SIZE), 10.0f);
    EQUAL(map.get(TextAttribute.WEIGHT), TextAttribute.WEIGHT_BOLD);
    EQUAL(map.get(TextAttribute.POSTURE), TextAttribute.POSTURE_OBLIQUE);

    tstyle = new TextStyle(Color.black, 14, false, false);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 2);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.black);
    EQUAL(map.get(TextAttribute.SIZE), 14.0f);
  }

  public void setColor()
  {
    MSG("FݒB");

    TextStyle tstyle = new TextStyle();
    tstyle.setColor(Color.red);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.red);

    tstyle.setColor(null);
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.FOREGROUND), Color.black);
  }

  public void setBackGroundColor()
  {
    MSG("wiFݒB");

    TextStyle tstyle = new TextStyle();
    tstyle.setBackGroundColor(Color.cyan);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.BACKGROUND), Color.cyan);

    tstyle.setBackGroundColor(ColorStyle.TRANSPARENT);
  }

  public void setSize()
  {
    MSG("TCYݒB");

    TextStyle tstyle = new TextStyle();
    tstyle.setSize(20);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.SIZE), 20.0f);

    tstyle.setSize(-1);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
  }

  public void setFontFamily()
  {
    MSG("tHgݒB");

    TextStyle tstyle = new TextStyle();
    tstyle.setFontFamily("");

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.FAMILY), "");

    tstyle.setFontFamily(null);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 0);
  }

  public void setBold()
  {
    MSG("{[ĥɂ邩ǂݒ肷B");

    TextStyle tstyle = new TextStyle();
    tstyle.setBold(true);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.WEIGHT), TextAttribute.WEIGHT_BOLD);

    tstyle.setBold(false);
    EQUAL(map.size(), 0);
  }

  public void setItalic()
  {
    MSG("C^bNɂ邩ǂݒ肷B");

    TextStyle tstyle = new TextStyle();
    tstyle.setItalic(true);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.POSTURE), TextAttribute.POSTURE_OBLIQUE);

    tstyle.setItalic(false);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 0);
  }

  public void setUnderline()
  {
    MSG("t邩ǂݒ肷B");

    TextStyle tstyle = new TextStyle();
    tstyle.setUnderline(true);

    Map<TextAttribute,Object> map = tstyle.getAttributeMap();
    EQUAL(map.size(), 1);
    EQUAL(map.get(TextAttribute.UNDERLINE), TextAttribute.UNDERLINE_ON);
    
    tstyle.setUnderline(false);
    map = tstyle.getAttributeMap();
    EQUAL(map.size(), 0);
  }
}
