package ts.graph;

import ts.tester.function.coverage.FunctionTester;
import java.awt.*;
import java.io.File;

public class LineStyleTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(LineStyleTest.class, (args.length > 0) ? args[0] : null);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test cases -- */

  public void constants()
  {
    EQUAL(LineStyle.TYPE_SOLID, 0);
    EQUAL(LineStyle.TYPE_DASH, 10);
    EQUAL(LineStyle.TYPE_ROUGH_DASH, 11);
    EQUAL(LineStyle.TYPE_FINE_DASH, 12);
    EQUAL(LineStyle.TYPE_DOT, 20);
    EQUAL(LineStyle.TYPE_ROUGH_DOT, 21);
    EQUAL(LineStyle.TYPE_FINE_DOT, 22);
  }

  public void constructor_color()
  {
    MSG("FɂƂRXgN^B");

    LineStyle lstyle = new LineStyle(Color.red);
    EQUAL(lstyle.getColor(), Color.red);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 1);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    NULL(stroke.getDashArray());
  }

  public void constructor_color_width()
  {
    MSG("FƑɂƂRXgN^B");

    LineStyle lstyle = new LineStyle(Color.blue, 3);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 3);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    NULL(stroke.getDashArray());
  }

  public void constructor_color_width_type()
  {
    MSG("FƑƎނɂƂRXgN^B");

    LineStyle lstyle = new LineStyle(Color.yellow, 5, LineStyle.TYPE_DOT);
    EQUAL(lstyle.getColor(), Color.yellow);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 5);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 1f);
    EQUAL(stroke.getDashArray()[1], 5f*3f);
  }

  public void constructor_color_width_type_cap_join()
  {
    MSG("FƑƎނƐ[ƐڍɂƂRXgN^B");

    LineStyle lstyle = new LineStyle(Color.red, 5,  LineStyle.TYPE_DASH,
      BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER);
    EQUAL(lstyle.getColor(), Color.red);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 5);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_ROUND);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_MITER);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 5f*2f);
    EQUAL(stroke.getDashArray()[1], 5f*3f);
  }

  public void constructor_color_width_dash_cap_join()
  {
    MSG("FƑƔjp^[Ɛ[ƌɂƂRXgN^B");

    float[] dash = {5f, 6f, 2f, 6f, 5f};
    LineStyle lstyle = new LineStyle(Color.blue, 3, dash,
      BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 3);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_BUTT);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_BEVEL);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 5);
    EQUAL(stroke.getDashArray()[0], 5f);
    EQUAL(stroke.getDashArray()[1], 6f);
    EQUAL(stroke.getDashArray()[2], 2f);
    EQUAL(stroke.getDashArray()[3], 6f);
    EQUAL(stroke.getDashArray()[4], 5f);
  }

  public void createStroke()
  {
    MSG("̎ނTYPE_SOLIDB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_SOLID);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray(), null);
  }

  public void createStroke_1()
  {
    MSG("̎ނTYPE_DASHB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_DASH);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 10f*2f);
    EQUAL(stroke.getDashArray()[1], 10f*3f);
  }

  public void createStroke_2()
  {
    MSG("̎ނTYPE_ROUGH_DASHB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_ROUGH_DASH);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 10f*2f);
    EQUAL(stroke.getDashArray()[1], 10f*5f);
  }

  public void createStroke_3()
  {
    MSG("̎ނTYPE_FINE_DASHB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_FINE_DASH);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 10f*2f);
    EQUAL(stroke.getDashArray()[1], 10f*2f);
  }

  public void createStroke_4()
  {
    MSG("̎ނTYPE_DOTB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_DOT);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 1f);
    EQUAL(stroke.getDashArray()[1], 10f*3f);
  }

  public void createStroke_5()
  {
    MSG("̎ނTYPE_ROUGH_DOTB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_ROUGH_DOT);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 1f);
    EQUAL(stroke.getDashArray()[1], 10f*5f);
  }

  public void createStroke_6()
  {
    MSG("̎ނTYPE_FINE_DOTB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, LineStyle.TYPE_FINE_DOT);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    EQUAL(stroke.getDashArray().length, 2);
    EQUAL(stroke.getDashArray()[0], 1f);
    EQUAL(stroke.getDashArray()[1], 10f*2f);
  }

  public void createStroke_7()
  {
    MSG("̎ނsB");

    LineStyle lstyle = new LineStyle(Color.blue, 10, 999);
    EQUAL(lstyle.getColor(), Color.blue);

    BasicStroke stroke = (BasicStroke) lstyle.getStroke();
    EQUAL(stroke.getLineWidth(), 10);
    EQUAL(stroke.getEndCap(), BasicStroke.CAP_SQUARE);
    EQUAL(stroke.getLineJoin(), BasicStroke.JOIN_ROUND);
    EQUAL(stroke.getMiterLimit(), 10.0);
    EQUAL(stroke.getDashPhase(), 0.0);
    NULL(stroke.getDashArray());
  }

  public void loadStyle()
  {
    MSG("OtBbNXEIuWFNgɃX^C𔽉fB");
    final String path = "test\\LineStyle\\loadStyle.png";

    File dir = new File("test\\LineStyle");
    dir.mkdir();

    LineStyle lstyle = new LineStyle(Color.blue, 2, LineStyle.TYPE_DASH);

    GraphImage gi = new GraphImage() {
      protected void drawGraph(Rectangle drawRect) {
        setLineStyle(new LineStyle(Color.blue, 10, LineStyle.TYPE_DASH));
        drawLine(50, 150, 100, 50);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.white);
    gi.setMargin(10, 10, 10, 10);
    gi.setBorderStyle(new LineStyle(Color.red, 2));

    try {
      gi.createImageFile(GraphImage.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
}

