/*
 * ThreadLifetimeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.lifetime.ThreadLifetime ThreadLifetime}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/06/25 16:20:45 $
 */
public class ThreadLifetimeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ThreadLifetimeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ThreadLifetime NX̋@\sB");
  }

  /* -- inner classes -- */

  void log(String msg) {
    System.out.println(msg);
  }
  
  class LifeA implements Life {
    public void wasBorn() {
      log(getClass().getSimpleName() + " was born!");
    }
    public void willDie() {
      log(getClass().getSimpleName() + " will die!");
    }
  }
  class LifeB extends LifeA {};
  class LifeC extends LifeA {};

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    NOTNULL(new ThreadLifetime());
  }

  public void setLifeLong()
  {
    MSG("ThreadIuWFNgɂ鐶Ԃ̐ݒ");

    Life lifeA0 = new LifeA();
    Life lifeB1 = new LifeB();
    Life lifeA2 = new LifeA();
    Life lifeC3 = new LifeC();

    ThreadLifetime lifetime0 = new ThreadLifetime();
    ThreadLifetime lifetime1 = new ThreadLifetime();
    ThreadLifetime lifetime2 = new ThreadLifetime();

    lifetime1.add(lifeA0);
    lifetime1.add(lifeB1);
    lifetime1.add(lifeA2);
    lifetime2.add(lifeC3);

    Thread th0 = new Thread() {
      public void run() {
        log("-- start thread 0.");
        try { sleep(5000); } catch (Exception e) {}
        log("-- end thread 0.");
      }
    };
    //lifetime0.setLifeLong(th0); --> XXX  // Set after starting thread.

    Thread th1 = new Thread() {
      public void run() {
        log("-- start thread 1.");
        try { sleep(10000); } catch (Exception e) {}
        log("-- end thread 1.");
      }
    };
    //lifetime1.setLifeLong(th0); --> XXX  // Set after starting thread.

    Thread th2 = new Thread() {
      public void run() {
        log("-- start thread 2.");
        try { sleep(3000); } catch (Exception e) {}
        log("-- end thread 2.");
      }
    };
    //lifetime2.setLifeLong(th0); --> XXX  // Set after starting thread.

    th0.start();
    lifetime0.setLifeLong(th0);
    th1.start();
    lifetime1.setLifeLong(th1);
    th2.start();
    lifetime2.setLifeLong(th2);

    log("# Exit after 20 seconds...");
    try {
      Thread.currentThread().sleep(20000);
    } catch (Exception e) {
      NG(e);
    }
    OK("# Complete.");
  }

  public void catchThreadException()
  {
    MSG("ÕLb`mFB");

    final Thread th = new Thread() {
      public void run() {
        try { sleep(1000); } catch (Exception e) {}
      }
    };
    ThreadLifetime lifetime0 = new ThreadLifetime() {
      public void threadEnded(Thread t) {
        throw new RuntimeException("G[");
      }
    };
    ThreadLifetime lifetime1 = new ThreadLifetime() {
      public void threadEnded(Thread t) {
        throw new RuntimeException("error");
      }
      public void catchThreadException(Exception e, Thread t) {
        EQUAL(e.getMessage(), "error");
        EQUAL(t, th);
      }
    };

    th.start();
    lifetime0.setLifeLong(th);
    lifetime1.setLifeLong(th);

    try { Thread.sleep(2000); } catch (Exception e) {}
  }
}

