/*
 * ReasonedExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.ReasonedException ReasonedException}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:07 $
 */
public class ReasonedExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ReasonedExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ReasonedException NX̋@\sB");
  }

  enum AAA { A };

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    try {
      throw new ReasonedException();
    } catch (ReasonedException e) {
      EQUAL(e.getReason(), null);
      EQUAL(e.getMessage(), null);
      EQUAL(e.getCause(), null);
    }
  }

  public void constructor_reason()
  {
    MSG("RɂƂRXgN^B");

    try {
      throw new ReasonedException(AAA.A);
    } catch (ReasonedException e) {
      TRUE(e.getReason() == AAA.A);
      EQUAL(e.getMessage(), null);
      EQUAL(e.getCause(), null);
    }
  }

  public void constructor_reason_msg()
  {
    MSG("RƃbZ[WɂƂRXgN^B");

    try {
      throw new ReasonedException(AAA.A, "abc");
    } catch (ReasonedException e) {
      TRUE(e.getReason() == AAA.A);
      EQUAL(e.getMessage(), "abc");
      EQUAL(e.getCause(), null);
    }
  }

  public void constructor_reason_msg_cause()
  {
    MSG("RƃbZ[WƌɂƂRXgN^B");

    Exception e0 = new Exception();
    try {
      throw new ReasonedException(AAA.A, "abc", e0);
    } catch (ReasonedException e) {
      TRUE(e.getReason() == AAA.A);
      EQUAL(e.getMessage(), "abc");
      EQUAL(e.getCause(), e0);
    }
  }

  public void constructor_reason_cause()
  {
    MSG("RƌɂƂRXgN^B");

    Exception e0 = new Exception();
    try {
      throw new ReasonedException(AAA.A, e0);
    } catch (ReasonedException e) {
      TRUE(e.getReason() == AAA.A);
      EQUAL(e.getMessage(), e0.getClass().getName());
      EQUAL(e.getCause(), e0);
    }
  }
}

