/*
 * StringConverter01CharTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import ts.tester.function.FunctionTester;
import java.text.*;

/**
 * <code>StringConverter</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:18 $
 */
public class StringConverter01CharTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(StringConverter01CharTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    StringConverter cnv = new StringConverter();
    NOTNULL(cnv);
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars()
  {
    MSG("k̏ꍇ");

    try {
      StringConverter.fromReadString(null, '\\', ",");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("", '|', null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_1()
  {
    MSG("ʏ̏ꍇ");

    try {
      EQUAL(StringConverter.fromReadString("abcdefg", '\\', ",\""), "abcdefg");
      EQUAL(StringConverter.fromReadString("   defg", '\\', ",\""), "defg");
      EQUAL(StringConverter.fromReadString(" \\ defg", '\\', ",\""), " defg");
      EQUAL(StringConverter.fromReadString(" defg  ", '\\', ",\""), "defg");

      EQUAL(StringConverter.fromReadString("a\\,bc", '\\', ",\""), "a,bc");
      EQUAL(StringConverter.fromReadString("ab\\\"c", '\\', ",\""), "ab\"c");
      EQUAL(StringConverter.fromReadString("ab\\\\c", '\\', ",\""), "ab\\c");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_2()
  {
    MSG("ꕶGXP[vĂȂꍇ");
    try {
      StringConverter.fromReadString("a,bc", '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 1);
      EQUAL(e.convertedString(), "a");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("ab\"c", '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "ab");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_3()
  {
    MSG("GXP[vŏIĂꍇ");

    try {
      StringConverter.fromReadString("abc\\", '\\', ",\"");
      NG();
    } catch (EndWithEscapeCharException e) {
      EQUAL(e.getStoppedIndex(), 3);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      EQUAL(StringConverter.fromReadString("abc \\  ", '\\', ",\"") + "<",
        "abc  <");
    } catch (Exception e) {
      NG(e);
    }

    try {
      NG(StringConverter.fromReadString("abc \\", '\\', ",\"") + "<");
    } catch (EndWithEscapeCharException e) {
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc ");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_4()
  {
    MSG("t@C̓ǂݍ݂z");

    String[] lines = {
      "This is a \\",
      "red pen.  "
    };

    StringBuilder buf = new StringBuilder();
    for (int i=0; i<lines.length; i++) {
      try {
        buf.append(StringConverter.fromReadString(lines[i], '\\', ""));
      }
      catch (EndWithEscapeCharException e) {
        buf.append(e.convertedString());
        continue;
      }
      catch (Exception e) {
        NG(e);
      }

      EQUAL(buf.toString(), "This is a red pen.");
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_5()
  {
    MSG("ꕶɃXy[X܂܂Ăꍇ");

    try {
      StringConverter.fromReadString("abc  ", '\\', " ");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 3);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_escape_specChars_6()
  {
    MSG("GXP[vAđꍇB");

    try {
      EQUAL(StringConverter.fromReadString("############", '#', "#"), "######");
    } catch (StringConvertException e) {
      NG(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars()
  {
    MSG("k̏ꍇ");

    try { 
      StringConverter.fromReadString(null, '\\', '(', ')', ",|\"");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try { 
      StringConverter.fromReadString("abc", '\\', '(', ')', null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_0()
  {
    MSG("ʏ̑");

    try {
      EQUAL(StringConverter.fromReadString("(abc)", '(', ')', '\\', ",\""),
        "abc");
      EQUAL(StringConverter.fromReadString("()", '(', ')', '\\', ",\""),
        "");
      EQUAL(StringConverter.fromReadString("(a\\(bc)", '(', ')', '\\', ",\""),
        "a(bc");
      EQUAL(StringConverter.fromReadString("(abc\\))", '(', ')', '\\', ",\""),
        "abc)");
      EQUAL(StringConverter.fromReadString("(ab\\\\c)", '(', ')', '\\', ",\""),
        "ab\\c");
      EQUAL(StringConverter.fromReadString("(\\\"abc)", '(', ')', '\\', ",\""),
        "\"abc");
      EQUAL(StringConverter.fromReadString("(  abc)", '(', ')', '\\', ",\""),
        "  abc");
      EQUAL(StringConverter.fromReadString("(abc  )", '(', ')', '\\', ",\""),
        "abc  ");
      EQUAL(StringConverter.fromReadString("(abc \\ )", '(', ')', '\\', ",\""),
        "abc  ");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_1()
  {
    MSG("ꕶGXP[vĂȂꍇ");

    try {
      StringConverter.fromReadString("(a(bc)", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "a");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(abc))", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\"abc)", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 1);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_2()
  {
    MSG("GXP[vŏIĂꍇ");

    try {
      StringConverter.fromReadString("(abc\\", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 5);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\\", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_3()
  {
    MSG("[ʂłȂꍇ");

    try {
      StringConverter.fromReadString("abc)", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 0);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(abc", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 0);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_4()
  {
    MSG("ʓ̕񂪃GXP[vŏIĂꍇ");

    try {
      StringConverter.fromReadString("(abc\\)", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e.toString());
      EQUAL(e.getStoppedIndex(), 5);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\\)", '(', ')', '\\', ",\"");
      NG();
    } catch (StringConvertException e) {
      OK(e.toString());
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void fromReadString_readStr_openPar_closePar_escape_specChars_5()
  {
    MSG("GXP[vAđꍇ");

    try {
      EQUAL("#####",
        StringConverter.fromReadString("############", '#', '#', '#', "#"));
    } catch (StringConvertException e) {
      NG(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void toWriteString_str_escape_specChars()
  {
    MSG("k̏ꍇ");

    try {
      StringConverter.toWriteString(null, '\\', "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("", '\\', null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void toWriteString_str_escape_specChars_0()
  {
    MSG("ʏ̑");

    EQUAL(StringConverter.toWriteString("", '\\', ""), "");
    EQUAL(StringConverter.toWriteString("abc", '\\', ",\""), "abc");
    EQUAL(StringConverter.toWriteString("a,bc", '\\', ",\""), "a\\,bc");
    EQUAL(StringConverter.toWriteString("ab\"c", '\\', ",\""), "ab\\\"c");
    EQUAL(StringConverter.toWriteString("abc\\", '\\', ",\""), "abc\\\\");
  }

  @Deprecated
  public void toWriteString_str_escape_specChars_1()
  {
    MSG("擪܂͖󔒂̏ꍇ");

    EQUAL(StringConverter.toWriteString("  abc", '\\', ",\""), "\\  abc");
    EQUAL(StringConverter.toWriteString("a bc  ", '\\', ",\""), "a bc \\ ");
    EQUAL(StringConverter.toWriteString(" abc ", '\\', ",\""), "\\ abc\\ ");
    EQUAL(StringConverter.toWriteString(" ", '\\', ",\""), "\\ ");
  }

  @Deprecated
  public void toWriteString_str_escape_specChars_2() throws Exception
  {
    MSG("fromReadStringŌɖ߂邩");

    char esc = '\\';
    String spec = ",\"";

    String s = "";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "abc";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "a,bc";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "ab\"c";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "abc\\";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "  abc";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = "a bc  ";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = " abc ";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);

    s = " ";
    EQUAL(StringConverter.fromReadString(
      StringConverter.toWriteString(s, esc, spec), esc, spec), s);
  }

  @Deprecated
  public void toWriteString_str_openPar_closePar_escape_specChars()
  {
    MSG("k̏ꍇ");

    try {
      StringConverter.toWriteString(null, '(', ')', '\\', "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("", '(', ')', '\\', null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  @Deprecated
  public void toWriteString_str_openPar_closePar_escape_specChars_0()
  {
    MSG("ʏ̑");

    EQUAL(StringConverter.toWriteString("", '(', ')', '\\', ""),
      "()");
    EQUAL(StringConverter.toWriteString("abc", '(', ')', '\\', ",\""),
      "(abc)");
    EQUAL(StringConverter.toWriteString("a,bc", '(', ')', '\\', ",\""),
      "(a\\,bc)");
    EQUAL(StringConverter.toWriteString("ab\"c", '(', ')', '\\', ",\""),
      "(ab\\\"c)");
    EQUAL(StringConverter.toWriteString("abc\\", '(', ')', '\\', ",\""),
      "(abc\\\\)");
    EQUAL(StringConverter.toWriteString("(abc", '(', ')', '\\', ",\""),
      "(\\(abc)");
    EQUAL(StringConverter.toWriteString(")abc", '(', ')', '\\', ",\""),
      "(\\)abc)");
    EQUAL(StringConverter.toWriteString("  abc", '(', ')', '\\', ",\""),
      "(  abc)");
    EQUAL(StringConverter.toWriteString("a bc  ", '(', ')', '\\', ",\""),
      "(a bc  )");
    EQUAL(StringConverter.toWriteString(" abc ", '(', ')', '\\', ",\""),
      "( abc )");
    EQUAL(StringConverter.toWriteString(" ", '(', ')', '\\', ",\""),
      "( )");
  }

  @Deprecated
  public void toWriteString_str_openPar_closePar_escape_specChars_2()
    throws Exception
  {
    MSG("fromReadStringŌɖ߂邩");

    char op = '(';
    char cp = ')';
    char esc = '\\';
    String spec = ",\"";

    String s = "";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "ab\"c";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "abc\\";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);
    
    s = "(abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = ")abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "  abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "a bc  ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = " abc ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = " ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);
  }

  @Deprecated
  public void toWriteString_str_escape_specChars_3()
    throws Exception
  {
    MSG("ꕶɋ󔒂܂܂Ăꍇ");

    EQUAL(StringConverter.toWriteString("abc  def ", '/', " ,"),
      "abc/ / def/ ");
  }

  @Deprecated
  public void toWriteString_str_openPar_closePar_escape_specChars_3()
    throws Exception
  {
    MSG("ꕶɋ󔒂܂܂Ăꍇ");

    EQUAL(StringConverter.toWriteString("abc  def ", '[', ']', '/', " ,"),
      "[abc/ / def/ ]");
  }
}
