/*
 * FileAlreadyExistsException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.IOException;

/**
 * pX̃t@Cɑ݂ꍇɃX[ONXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:08 $
 */
public class FileAlreadyExistsException extends IOException
{
  /** ̃NX̃VAo[WIDB */
  static final long serialVersionUID = -8313965674157217994L;

  /** t@CpXB */
  private String path_ ;

  /**
   * t@CpXɂƂRXgN^B
   * <br>
   * ̃t@CpXk̏ꍇÂ܂܎󂯕tB
   *
   * @param  path t@CpXB
   */
  public FileAlreadyExistsException(String path)
  {
    path_ = path;
  }

  /**
   * t@CpXƗObZ[WɂƂRXgN^B
   * <br>
   * ̃t@CpXk̏ꍇÂ܂܎󂯕tB
   * ̗ObZ[Wk̏ꍇÂ܂܎󂯕tB
   *
   * @param  path t@CpXB
   * @param  msg  ObZ[WB
   */
  public FileAlreadyExistsException(String path, String msg)
  {
    super(msg);
    path_ = path;
  }

  /**
   * t@CpX擾B
   *
   * @return t@CpXB
   */
  public String getPath()
  {
    return path_ ;
  }

  /**
   * O̓e\擾B
   *
   * @return O̓e\B
   */
  public String toString()
  {
    String s = getMessage();
    if (s == null) {
      s = "The file already exists";
    }
    return getClass().getName() + ": " + s + ": " + getPath();
  }
}
