/*
 * ConsolePrinter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.coverage.Coverage;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.Result;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.Location;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;

/**
 * @\ʂR\[o͂
 * {@link ts.tester.function.print.ConsolePrinterBase ConsolePrinterBase}
 * NXAJobWvʂo͂悤ɊgNXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class ConsolePrinter extends ConsolePrinterBase
  implements CoveragePrinter
{
  /** \[Xt@CpX̃XgB */
  private List<String> sourcePathLst_ = new LinkedList<String>();

  /**
   * ftHgRXgN^B
   */
  public ConsolePrinter()
  {}

  /**
   * o̓IuWFNgɂƂRXgN^B
   *
   * @param  writer o̓IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public ConsolePrinter(PrintWriter writer)
  {
    super(writer);
  }

  /**
   * JobWv̏sB
   *
   * @param  coverage JobWvIuWFNgB
   */
  public void prepareCoverage(Coverage coverage)
  {}

  /**
   * JobWv̌㏈sB
   *
   * @param  coverage JobWvIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void postCoverage(Coverage coverage)
  {
    assert (coverage != null) : "@param:coverage is null.";

    if (coverage instanceof LineCoverage) {
      printLineCoverage((LineCoverage) coverage);
    }
  }

  /**
   * NX̓o^ɌĂяo郁\bhB
   *
   * @param refType o^ꂽNX̓C^[tFCX
   *          {@link com.sun.jdi.ReferenceType ReferenceType}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void entryClass(ReferenceType refType)
  {
    assert (refType != null) : "@param:refType is null.";

    try {
      List<String> srcLst = refType.sourcePaths(null);
      for (String src : srcLst) {
        if (! sourcePathLst_.contains(src)) {
          sourcePathLst_.add(src);
        }
      }
    } catch (Exception e) {}
  }

  /**
   * s̓o^ɌĂяo郁\bhB
   *
   * @param  location  o^ꂽs{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  public void entryLine(Location location)
  {}

  /**
   * \bhĂяoɌĂяo郁\bhB
   *
   * @param  method Ăяoꂽ\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  public void entryMethod(Method method)
  {}

  /**
   * \bhIɌĂяo郁\bhB
   *
   * @param  method I\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  public void exitMethod(Method method)
  {}

  /**
   * s̒ʉߎɌĂяo郁\bhB
   *
   * @param  location ʉ߂s{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  public void passLine(Location location)
  {}

  /**
   * sJobW̌vʂ\B
   *
   * @param  coverage {@link ts.tester.coverage.LineCoverage LineCoverage}
   *           IuWFNgB
   */
  protected void printLineCoverage(LineCoverage coverage)
  {
    writer().println();
    writer().println("Coverage ==>");

    Iterator<String> it = sourcePathLst_.iterator();
    while (it.hasNext()) {
      String sourcePath = it.next();
      Result<Integer> r = coverage.getPassResult(sourcePath);
      StringBuffer buf = new StringBuffer();
      buf.append(" + ");
      buf.append(sourcePath);
      buf.append(": ");
      buf.append(r.passedRatio() * 100.0f);
      buf.append("% (");
      buf.append(r.countPassedResults());
      buf.append(" / ");
      buf.append(r.countAllResults());
      buf.append(" lines)");
      writer().println(buf.toString());

      if (r.passedRatio() < 1.0f) {
        buf = new StringBuffer();
        buf.append("   {");
  
        Enumeration<Integer> e = r.enumNotPassedResultKeys();
        while (e.hasMoreElements()) {
          Integer line = e.nextElement();
          if (r.getPassCountOfResult(line) == 0) {
            buf.append(" ").append(line);
          }
        }
        buf.append(" }");
        writer().println(buf.toString());
      }
    }
    writer().flush();
  }
}
