/*
 * ObjectWriter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.util.ObjectSerializer;
import ts.util.text.StringConverter;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.InvalidClassException;
import java.io.IOException;

/**
 * JobWsvZXIuWFNgo߂̎dg݂񋟂
 * NXB
 * <br>
 * {@link
 * ts.tester.coverage.Coverage#setObjectWriter(ts.tester.coverage.ObjectWriter) 
 * Coverage#setObjectWriter}\bhgăJobWIuWFNgɐݒ肷B
 * āAJobWsvZXŁÃNX static \bh {@link
 * ts.tester.coverage.ObjectWriter#outputObject outputObject} sƁA
 * Ɏw肳ꂽIuWFNg
 * {@link ts.tester.coverage.ObjectWriter#writeObject writeObject}\bh
 * ƂĎoƂłB
 * <br>
 * AAoIuWFNg {@link java.io.Serializable Serializable}
 * C^[tFCXCvgĂKvB
 *
 * @author  VB
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:19:59 $
 */
public class ObjectWriter
{
  /** ɃVACYꂽIuWFNg̊JnB */
  private static final char START_CHAR = '\u0002';

  /** ɃVACYꂽIuWFNg̏IB */
  private static final char END_CHAR = '\u0003';

  /** ꕶ̃GXP[vB*/
  private static final char ESC_CHAR = '\u001b';

  /** VACYꂽIuWFNg̕i[obt@B */
  private StringBuffer objBuf_ = null;

  /** kVACY\ȃIuWFNgB */
  private final static Null NULL = new Null();

  /** Xg[o̓IuWFNgB */
  private OutputStreamWriter streamWriter_ = null;

  /**
   * JobWsvZXpɕWo͋yѕWG[o͂B
   */
  public static void prepareOutput()
  {
    System.setOut(new ObjectPrintStream(System.out));
    System.setErr(new ObjectPrintStream(System.err));
  }

  /**
   * IuWFNgJobWsvZXO֏o͂B
   *
   * @param  obj JobWsvZXO֏o͂IuWFNgB
   * @throws java.io.InvalidClassException w肳ꂽIuWFNg̃NX
   *           VACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.IOException VACYɓo̓G[ꍇB
   */
  public static void outputObject(Serializable obj)
    throws InvalidClassException, IOException
  {
    if (obj == null) {
      obj = NULL;
    }
    String s = ObjectSerializer.serializeToString(obj);

    PrintStream ps = System.out;
    if (System.out instanceof ObjectPrintStream) {
      ObjectPrintStream ops = (ObjectPrintStream) System.out;
      ps = ops.getBarePrintStream();
    }
    ps.print(START_CHAR + s + END_CHAR);
    ps.flush();
  }

  /**
   * Xg[o̓IuWFNgݒ肷B
   *
   * @param streamWriter Xg[o̓IuWFNgB
   */
  void setStreamWriter(OutputStreamWriter streamWriter)
  {
    streamWriter_ = streamWriter;
  }

  /**
   * JobWsvZXoꂽXg[A
   * IuWFNgo̓IuWFNg܂̓Xg[o̓IuWFNgɐU蕪
   * o͂B
   *
   * @param  cBuf JobWsvZXoꂽXg[B
   * @param  len  Xg[̒B
   * @throws ClassNotFoundException fVACYIuWFNg̃NX
   *           ȂꍇB
   * @throws IOException o͏ɗOꍇB
   * @throws AssertionError ̃Xg[񂪃k̏ꍇA͈
   *           Xg[̒sȏꍇA̓Xg[o̓IuWFN
   *           gk̏ꍇifobO[ĥ݁jB
   */
  final void writeObjectOrStream(char[] cBuf, int len)
    throws ClassNotFoundException, IOException
  {
    assert (cBuf != null) : "@param:cBuf is null.";
    assert (len >= 0) : "@param:len is negative.";
    assert (len <= cBuf.length) : "@param:len is too large.";
    assert (streamWriter_ != null) : "@param:streamWriter_ is null.";

    StringBuilder strBuf = new StringBuilder();
    boolean isEscaped = false;
    for (int i=0; i<len; i++) {
      if (isEscaped) {
        strBuf.append(cBuf[i]);
        isEscaped = false;
      }
      else if (cBuf[i] == ESC_CHAR) {
        if (objBuf_ == null) {
          isEscaped = true;
        }
        else {
          objBuf_.append(cBuf[i]);
        }
      }
      else if (cBuf[i] == START_CHAR) {
        if (objBuf_ == null && strBuf.length() > 0) {
          streamWriter_.write(strBuf.toString());
          streamWriter_.flush();
        }
        objBuf_ = new StringBuffer();
        continue;
      }
      else if (cBuf[i] == END_CHAR) {
        if (objBuf_ != null) {
          Object obj = ObjectSerializer.deserialize(objBuf_.toString());
          writeObject((obj instanceof Null) ? null : obj);
          objBuf_ = null;
        }
        strBuf = new StringBuilder();
      }
      else {
        if (objBuf_ != null) {
          objBuf_.append(cBuf[i]);
        }
        else {
          strBuf.append(cBuf[i]);
        }
      }
    }

    if (objBuf_ == null && strBuf.length() > 0) {
      streamWriter_.write(strBuf.toString());
      streamWriter_.flush();
    }
  }

  /**
   * JobWsvZXoꂽIuWFNg̏o͏sB
   *
   * @param  obj JobWsvZXoꂽIuWFNgB
   */
  protected void writeObject(Object obj)
  {}

  /* -- inner class --*/

  /**
   * k̑ƂȂVACY\NXB
   */
  private static class Null implements Serializable
  {
    static final long serialVersionUID = 862525238995100138L;
  }

  /**
   * JobWsvZXŁAWo͋yѕWG[o͂Ɏgp
   * o̓Xg[ENXB
   */
  private static class ObjectPrintStream extends PrintStream
  {
    /** RXgN^Ŏw肳ꂽ{@link java.io.PrintStream} IuWFNgB*/
    private PrintStream printStream_ ;

    /**
     * {@link java.io.PrintStream PrintStream}IuWFNgɂƂ
     * RXgN^B
     *
     * @param  ps {@link java.io.PrintStream PrintStream}IuWFNg
     */
    public ObjectPrintStream(PrintStream ps)
    {
      super(ps);

      printStream_ = ps;
    }

    /**
     * RXgN^Ŏw肳ꂽ{@link java.io.PrintStream} IuWFNg
     * 擾B
     *
     * @return {@link java.io.PrintStream} IuWFNgB
     */
    PrintStream getBarePrintStream()
    {
      return printStream_ ;
    }
    
    /**
     * oCgXg[ɏo͂B
     *
     * @param  x oCgB
     * @param  off JnCfbNXB
     * @param  len o͂钷B
     */
    public void write(byte[] x, int off, int len)
    {
      int n = len;
      for (int i=off; i<off+len; i++) {
        switch (x[i]) {
        case (byte) START_CHAR :
        case (byte) END_CHAR :
        case (byte) ESC_CHAR :
          n ++;
          break;
        }
      }

      byte[] bsq = new byte[n];
      for (int i=0,j=0; i<len; i++,j++) {
        switch (x[i]) {
        case (byte) START_CHAR :
        case (byte) END_CHAR :
        case (byte) ESC_CHAR :
          bsq[j] = (byte) ESC_CHAR;
          j ++;
          break;
        }
        bsq[j] = x[i];
      }

      super.write(bsq, 0, n);
    }

    /**
     * <code>int</code>lXg[ɏo͂B
     *
     * @param  b <code>int</code>lB
     */
    public void write(int b)
    {
      switch (b) {
      case (int) START_CHAR :
      case (int) END_CHAR :
      case (int) ESC_CHAR :
        synchronized (this) {
          super.write((int) ESC_CHAR);
          super.write(b);
        }
        break;
      default:
        super.write(b);
        break;
      }
    }
  }
}
