/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;

public class FileSizeFilter
implements FileFilter {
    private long sizeFrom_ = -1L;
    private long sizeTo_ = -1L;

    public FileSizeFilter(long l, long l2) {
        if (l >= 0L && l2 >= 0L) {
            if (l <= l2) {
                this.sizeFrom_ = l;
                this.sizeTo_ = l2;
            } else {
                this.sizeFrom_ = l2;
                this.sizeTo_ = l;
            }
        } else {
            this.sizeFrom_ = l < 0L ? -1L : l;
            this.sizeTo_ = l2 < 0L ? -1L : l2;
        }
    }

    public boolean accept(File file) {
        assert (file != null) : "@param:file is null.";
        if (this.sizeFrom_ >= 0L && file.length() < this.sizeFrom_) {
            return false;
        }
        return this.sizeTo_ < 0L || file.length() <= this.sizeTo_;
    }
}

