/*
 * ClassReloader class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.util;

import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/**
 * NXt@C[h邽߂̃NXB 
 * <br>
 * w肳ꂽÕNXANXt@Cjart@CAXg[
 * ēǂݍ݂邽߂̃\bhpӂĂB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class ClassReloader
{
  /** ̃NXŎgpNX[_IuWFNgB */
  private PrivateClassLoader classLoader_ ;

  /**
   * ftHgRXgN^B
   */
  public ClassReloader()
  {
    classLoader_ = new PrivateClassLoader();
  }

  /**
   * w肳ꂽÕNXNXpXTčēǂݍ݂sA
   * NXIuWFNg쐬B
   *
   * @param  className NXB
   * @return NXIuWFNgB
   * @throws ClassNotFoundException w肳ꂽÕNXȂꍇB
   * @throws IOException NXt@C̓ǂݍ݂ɎsꍇB
   * @throws ClassFormatError ǂݍ񂾃t@Č`NXt@CłȂ
   *           ꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Class reloadClass(String className)
    throws ClassNotFoundException, IOException, ClassFormatError
  {
    assert (className != null) : "@param:className is null.";

    return reloadClass(className, System.getProperty("java.class.path"));
  }

  /**
   * w肳ꂽÕNXw肳ꂽNXpXTčēǂݍ݂sA
   * NXIuWFNg쐬B
   *
   * @param  className NXB
   * @param  classpaths NXpXB
   * @return NXIuWFNgB
   * @throws ClassNotFoundException w肳ꂽÕNXȂꍇB
   * @throws IOException NXt@C̓ǂݍ݂ɎsꍇB
   * @throws ClassFormatError ǂݍ񂾃t@Č`NXt@CłȂ
   *           ꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Class reloadClass(String className, String classpaths)
    throws ClassNotFoundException, IOException, ClassFormatError
  {
    assert (className != null) : "@param:className is null.";
    assert (classpaths != null) : "@param:classpaths is null.";

    byte[] bytes = loadClassBytes(className, classpaths);
    return classLoader_.bytesToClass(className, bytes);
  }

  /**
   * w肳ꂽÕNXAw肳ꂽNXpXTāANXt@C
   * ̃oCg擾B
   *
   * @param  className NXB
   * @param  classPaths NXpXB
   * @return NXt@C̃oCgB
   * @throws ClassNotFoundException w肳ꂽÕNXȂꍇB
   * @throws IOException NXt@C̓ǂݍ݂ɎsꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected byte[] loadClassBytes(String className, String classPaths)
    throws ClassNotFoundException, IOException
  {
    assert (className != null) : "@param:className is null.";
    assert (classPaths != null) : "@param:classPaths is null.";

    String clsFileName = className.replace('.', File.separatorChar) + ".class";
    String clsFileName2 = className.replace('.', '/') + ".class";

    StringTokenizer st = new StringTokenizer(classPaths, File.pathSeparator);
    while (st.hasMoreTokens()) {
      File file = new File(st.nextToken());
      if (! file.exists())
        continue;

      if (file.isDirectory()) {
        File classFile = new File(file, clsFileName);
        if (! classFile.exists())
          continue;

        FileInputStream fis = null;
        try {
          byte[] b = new byte[(int) classFile.length()];
          fis = new FileInputStream(classFile);
          fis.read(b);
          return b;
        }
        finally {
          if (fis != null)
            try { fis.close(); } catch (Exception e) {}
        }
      }
      else {
        JarFile jarFile = null;
        try {
          jarFile = new JarFile(file, true);
          JarEntry entry = jarFile.getJarEntry(clsFileName2);
          if (entry == null)
            continue;

          InputStream istream = jarFile.getInputStream(entry);
          byte[] b = new byte[(int) entry.getSize() ];
          istream.read(b);
          istream.close();
          return b;
        }
        finally {
          if (jarFile != null)
            try { jarFile.close(); } catch (Exception e) {} 
        }
      }
    }

    throw new ClassNotFoundException(className);
  }

  /* -- inner classes -- */

  /**
   * {@link ts.tester.tech.ClassReloader ClassReloader}NXŎgp
   * NX[_B
   *
   * @author V.
   * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
   */
  private class PrivateClassLoader extends ClassLoader
  {
    /** 
     * w肳ꂽoCgNXIuWFNgɕϊB
     *
     * @param  className NXB
     * @param  bytes oCgB
     * @return ϊꂽNXIuWFNgB
     * @throws ClassFormatError oCg񂪃NXƂėLȌ`łȂꍇB
     */
    Class bytesToClass(String className, byte[] bytes) throws ClassFormatError
    {
      return defineClass(className, bytes, 0, bytes.length);
    }
  }
}
