/*
 * ClassReloaderTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.*;

/**
 * <code>ClassReloader</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class ClassReloaderTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ClassReloaderTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mF");
    ClassReloader reloader = new ClassReloader();
    NOTNULL(reloader);
  }

  public void loadClassBytes_className_classPath()
  {
    MSG("ʏ̑");

    ClassReloader reloader = new ClassReloader();

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];

    ObjectInspector oi = new ObjectInspector(this);
    try {
      values[0] = this.getClass().getName();
      values[1] = System.getProperty("java.class.path");
      Object ret = oi.invokeMethod(reloader, "loadClassBytes", types, values);
      EQUAL(ret.getClass(), byte[].class);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void loadClassBytes_className_classPath_01()
  {
    MSG("k̏ꍇ");

    ClassReloader reloader = new ClassReloader();

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];

    ObjectInspector oi = new ObjectInspector(this);
    try {
      values[0] = null;
      values[1] = null;
      oi.invokeMethod(reloader, "loadClassBytes", types, values);
      NG();
    }
    catch (java.lang.reflect.InvocationTargetException e) {
      try {
        throw e.getCause();
      } catch (AssertionError e2) {
        OK(e2.toString());
      } catch (Throwable e2) {
        NG(e2.toString());
      }
    }
    catch (AssertionError e) {
      OK(e.toString());
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      values[0] = null;
      values[1] = System.getProperty("java.class.path");
      oi.invokeMethod(reloader, "loadClassBytes", types, values);
      NG();
    }
    catch (java.lang.reflect.InvocationTargetException e) {
      try {
        throw e.getCause();
      } catch (AssertionError e2) {
        OK(e2.toString());
      } catch (Throwable e2) {
        NG(e2.toString());
      }
    }
    catch (AssertionError e) {
      OK(e.toString());
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      values[0] = this.getClass().getName();
      values[1] = null;
      oi.invokeMethod(reloader, "loadClassBytes", types, values);
      NG();
    }
    catch (java.lang.reflect.InvocationTargetException e) {
      try {
        throw e.getCause();
      } catch (AssertionError e2) {
        OK(e2.toString());
      } catch (Throwable e2) {
        NG(e2.toString());
      }
    }
    catch (AssertionError e) {
      OK(e.toString());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void loadClassBytes_className_classPath_02()
  {
    MSG("w肳ꂽNXȂꍇ");

    ClassReloader reloader = new ClassReloader();

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];

    ObjectInspector oi = new ObjectInspector(this);
    try {
      values[0] = "xxx.yyy.ZZZ";
      values[1] = System.getProperty("java.class.path");
      oi.invokeMethod(reloader, "loadClassBytes", types, values);
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      values[0] = "java.lang.String";
      values[1] = "classes";
      oi.invokeMethod(reloader, "loadClassBytes", types, values);
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void loadClassBytes_className_classPath_03()
  {
    MSG("NXpXɓo^ꂽfBNgNX[h");

    ClassReloader reloader = new ClassReloader();
    ObjectInspector oi = new ObjectInspector(this);

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];
    try {
      values[0] = "ts.tester.TesterTest";
      values[1] = "test";
      Object ret = oi.invokeMethod(reloader, "loadClassBytes", types, values);
      EQUAL(ret.getClass(), byte[].class);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void loadClassBytes_className_classPath_04()
  {
    MSG("jart@CNX[h");

    ClassReloader reloader = new ClassReloader();
    ObjectInspector oi = new ObjectInspector(this);

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];
    try {
      values[0] = "ts.util.file.FileOperation";
      values[1] = "lib/ts-util.jar";
      Object ret = oi.invokeMethod(reloader, "loadClassBytes", types, values);
      EQUAL(ret.getClass(), byte[].class);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void loadClassBytes_className_classPath_05()
  {
    MSG("݂ȂpXNXpXɊ܂߂ꍇ");

    ClassReloader reloader = new ClassReloader();
    ObjectInspector oi = new ObjectInspector(this);

    Class[] types = { String.class, String.class };
    Object[] values = new Object[2];
    try {
      values[0] = "ts.tester.TesterTest";
      values[1] = "testtest;test";
      Object ret = oi.invokeMethod(reloader, "loadClassBytes", types, values);
      EQUAL(ret.getClass(), byte[].class);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths()
  {
    MSG("ʏ̑");

    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass(
        this.getClass().getName(), System.getProperty("java.class.path"));
      EQUAL(c.getName(), this.getClass().getName());
      FALSE(c.equals(this.getClass()));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths_01()
  {
    MSG("k̏ꍇ");

    ClassReloader reloader = new ClassReloader();
    try {
      reloader.reloadClass(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      reloader.reloadClass(null, System.getProperty("java.class.path"));
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      reloader.reloadClass(this.getClass().getName(), null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths_02()
  {
    MSG("w肳ꂽÕNXȂꍇ");

    ClassReloader reloader = new ClassReloader();
    try {
      reloader.reloadClass(
        "xxx.yyy.ZZZ", System.getProperty("java.class.path"));
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      reloader.reloadClass("java.lang.String", "classes");
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths_03()
  {
    MSG("NXpXɓo^ꂽfBNgNXǂݍޏꍇ");
    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass("ts.tester.TesterTest", "test");
      EQUAL(c.getName(), "ts.tester.TesterTest");
      FALSE(c.equals(ts.tester.TesterTest.class));
    } catch (Exception e) {
      NG(e);
    }

    try {
      reloader.reloadClass("ts.tester.TesterTest", "classes");
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths_04()
  {
    MSG("jart@CNXǂݍޏꍇ");
    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass(
        "ts.util.file.FileOperation", "lib/ts-util.jar");
      EQUAL(c.getName(), "ts.util.file.FileOperation");
      FALSE(c.equals(ts.util.file.FileOperation.class));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_classpaths_05()
  {
    MSG("Ⴄ`̃t@Cǂݍ񂾏ꍇ");

    File file = new File("aaa.class");
    try {
      file.createNewFile();
    } catch (Exception e) {
      NG(e);
    }

    ClassReloader reloader = new ClassReloader();
    try {
      reloader.reloadClass("aaa", ".");
      NG();
    } catch (ClassFormatError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    file.delete();
  }

  public void reloadClass_className()
  {
    MSG("ʏ̏ꍇ");
    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass(this.getClass().getName());
      EQUAL(c.getName(), this.getClass().getName());
      FALSE(c.equals(this.getClass()));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_01()
  {
    MSG("k̏ꍇ");
    ClassReloader reloader = new ClassReloader();
    try {
      reloader.reloadClass(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_02()
  {
    MSG("w肳ꂽÕNX݂Ȃꍇ");
    ClassReloader reloader = new ClassReloader();
    try {
      reloader.reloadClass("xxx.yyy.ZZZ");
      NG();
    } catch (ClassNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_03()
  {
    MSG("NXpXɓo^ĂfBNgɂNX[h");
    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass("ts.tester.TesterTest");
      EQUAL(c.getName(), "ts.tester.TesterTest");
      FALSE(c.equals(ts.tester.TesterTest.class));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void reloadClass_className_04()
  {
    MSG("jart@CɊi[ĂNX[h");
    ClassReloader reloader = new ClassReloader();
    try {
      Class c = reloader.reloadClass("ts.util.file.FileOperation");
      EQUAL(c.getName(), "ts.util.file.FileOperation");
      FALSE(c.equals(ts.util.file.FileOperation.class));
    } catch (Exception e) {
      NG(e);
    }
  }
}
