/*
 * ConsolePrinterBaseTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.*;
import java.io.*;

/**
 * <code>ConsolePrinterBase</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class ConsolePrinterBaseTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ConsolePrinterBaseTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  final static String EOL ;

  static {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println();
    EOL = sw.toString();
    try {
      pw.close();
    } catch (Exception e) {}
  }

  /* -- test case -- */

  public void constructor()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    NOTNULL(printer);
  }

  public void constructor_writer()
  {
    MSG("k̏ꍇ");
    try {
      ConsolePrinterBase printer = new ConsolePrinterBase(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_writer_1()
  {
    MSG("ʏ̑̏ꍇ");
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);

    ConsolePrinterBase printer = new ConsolePrinterBase(pw);
    CaseResult c = printer.createCaseResult("", CaseResult.NULL);
    printer.messageNoted("", c);
    EQUAL(sw.toString(), " " + EOL);

    try {
      sw.close();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createCaseResult()
  {
    MSG("ʏ̑̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult result = printer.createCaseResult("ABC", CaseResult.NULL);
    EQUAL(result.getName(), "ABC");
    EQUAL(result.getParentCaseResult(), CaseResult.NULL);
  }

  public void createCaseResult_01()
  {
    MSG("k̏ꍇ");

    ConsolePrinterBase printer = new ConsolePrinterBase();

    try {
      printer.createCaseResult(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult("ABC", null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStarted()
  {
    MSG("ʏ̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.testStarted(c);
    OK();
  }

  public void testStarted_0()
  {
    MSG("k̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    try {
      printer.testStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded()
  {
    MSG("ʏ̑");

    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("abc", CaseResult.NULL);
    printer.testEnded(c);
    OK();
  }

  public void testEnded_0()
  {
    MSG("k̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    try {
      printer.testEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseStarted()
  {
    MSG("ʏ̑");

    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("abc", CaseResult.NULL);
    printer.caseStarted(c);
    OK();
  }

  public void caseStarted_0()
  {
    MSG("k̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    try {
      printer.caseStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseEnded()
  {
    MSG("ʏ̏ꍇ");

    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("abc", CaseResult.NULL);
    printer.caseEnded(c);
    OK();
  }

  public void caseEnded_0()
  {
    MSG("k̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    try {
      printer.caseEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }
 
  public void checkOccured()
  {
    MSG("ʏ̏ꍇ");

    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("abc", CaseResult.NULL);
    printer.checkOccured(CheckResult.OK(), c);
    OK();
  }

  public void checkOccured_0()
  {
    MSG("k̏ꍇ");
    ConsolePrinterBase printer = new ConsolePrinterBase();
    try {
      printer.checkOccured(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.checkOccured(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.checkOccured(CheckResult.NG(), null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void messageNoted()
  {
    MSG("ʏ̏ꍇ");

    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);

    ConsolePrinterBase printer = new ConsolePrinterBase(pw);
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c);
    printer.messageNoted("XYZ", c2);
    EQUAL(sw.toString(), "  XYZ" + EOL);

    try {
      sw.close(); 
    } catch (Exception e) {
      NG(e);
    }
  }

  public void messageNoted_0()
  {
    MSG("k̏ꍇ");

    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);

    ConsolePrinterBase printer = new ConsolePrinterBase(pw);
    try {
      printer.messageNoted(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.messageNoted(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.messageNoted("abc", null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      sw.close(); 
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _CaseResult_addChildResult_result()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    EQUAL(c.count(ResultType.OK), 0);
    EQUAL(c.count(ResultType.NG), 0);
    EQUAL(c.count(ResultType.Empty), 0);
    EQUAL(c.count(ResultType.KnownBug), 0);
    EQUAL(c.count(ResultType.Incomplete), 0);

    c.addChildResult(CheckResult.OK());
    EQUAL(c.count(ResultType.OK), 1);
    EQUAL(c.count(ResultType.NG), 0);
    EQUAL(c.count(ResultType.Empty), 0);
    EQUAL(c.count(ResultType.KnownBug), 0);
    EQUAL(c.count(ResultType.Incomplete), 0);

    c.addChildResult(CheckResult.NG());
    EQUAL(c.count(ResultType.OK), 1);
    EQUAL(c.count(ResultType.NG), 1);
    EQUAL(c.count(ResultType.Empty), 0);
    EQUAL(c.count(ResultType.KnownBug), 0);
    EQUAL(c.count(ResultType.Incomplete), 0);
  }

  public void _CaseResult_printAsTestStarted()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    ObjectInspector oi = new  ObjectInspector(this);

    try {
      CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
      oi.invokeMethod(c1, "printAsTestStarted");

      CaseResult c2 = printer.createCaseResult("bbb", c1);
      oi.invokeMethod(c2, "printAsTestStarted");

      CaseResult c3 = printer.createCaseResult("bbb", c2);
      oi.invokeMethod(c3, "printAsTestStarted");

      OK();
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void _CaseResxult_printAsTestEnded()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    ObjectInspector oi = new ObjectInspector(this);

    try {
      CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
      CaseResult c2 = printer.createCaseResult("bbb", c1);

      c2.addChildResult(CheckResult.OK());
      c2.addChildResult(CheckResult.NG());
      c2.addChildResult(CheckResult.KnownBug());
      c2.addChildResult(CheckResult.Empty());
      c2.addChildResult(CheckResult.Incomplete());

      oi.invokeMethod(c2, "printAsTestEnded");
      oi.invokeMethod(c1, "printAsTestEnded");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _CaseResult_printAsCaseStarted()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    ObjectInspector oi = new ObjectInspector(this);

    try {
      CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
      CaseResult c2 = printer.createCaseResult("bbb", c1);
      CaseResult c3 = printer.createCaseResult("ccc", c2);

      oi.invokeMethod(c1, "printAsCaseStarted");
      oi.invokeMethod(c2, "printAsCaseStarted");
      oi.invokeMethod(c3, "printAsCaseStarted");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _CaseResult_printAsCaseEnded()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    ObjectInspector oi = new ObjectInspector(this);
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("bbb", c2);

    try {
      oi.invokeMethod(c1, "printAsCaseEnded");
      oi.invokeMethod(c2, "printAsCaseEnded");
      oi.invokeMethod(c3, "printAsCaseEnded");
      OK();
    } catch (Exception e) {
      NG(e);
    }

    c3.addChildResult(CheckResult.Incomplete());

    try {
      oi.invokeMethod(c1, "printAsCaseEnded");
      oi.invokeMethod(c2, "printAsCaseEnded");
      oi.invokeMethod(c3, "printAsCaseEnded");
      OK();
    } catch (Exception e) {
      NG(e);
    }

    c3.addChildResult(CheckResult.Empty());

    try {
      oi.invokeMethod(c1, "printAsCaseEnded");
      oi.invokeMethod(c2, "printAsCaseEnded");
      oi.invokeMethod(c3, "printAsCaseEnded");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _CaseResult_printCheck()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("ccc", c2);

    ObjectInspector oi = new ObjectInspector(this);

    try {
      oi.invokeMethod(c1, "printCheck", CheckResult.class, CheckResult.OK());
      oi.invokeMethod(c2, "printCheck", CheckResult.class, CheckResult.OK());
      oi.invokeMethod(c3, "printCheck", CheckResult.class, CheckResult.OK());
      OK();
    } catch (Exception e) {
      NG(e);
    }

    try {
      CheckResult chk = CheckResult.OK();
      chk.setResultValue(new Integer(1));
      oi.invokeMethod(c1, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c2, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c3, "printCheck", CheckResult.class, chk);
      OK();
    } catch (Exception e) {
      NG(e);
    }

    try {
      CheckResult chk = CheckResult.NG();
      chk.setResultValue(new Integer(1));
      chk.setExpectValue(new Integer(2));
      oi.invokeMethod(c1, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c2, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c3, "printCheck", CheckResult.class, chk);
      OK();
    } catch (Exception e) {
      NG(e);
    }

    try {
      CheckResult chk = CheckResult.NG("XXXXXXXXXXXX");
      oi.invokeMethod(c1, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c2, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c3, "printCheck", CheckResult.class, chk);
      OK();
    } catch (Exception e) {
      NG(e);
    }

    try {
      CheckResult chk = CheckResult.OK("Match");
      oi.invokeMethod(c1, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c2, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c3, "printCheck", CheckResult.class, chk);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void printCheck_KnownBug()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("ccc", c2);

    ObjectInspector oi = new ObjectInspector(this);

    try {
      oi.invokeMethod(c1,"printCheck",CheckResult.class,CheckResult.KnownBug());
      oi.invokeMethod(c2,"printCheck",CheckResult.class,CheckResult.KnownBug());
      oi.invokeMethod(c3,"printCheck",CheckResult.class,CheckResult.KnownBug());
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void printCheck_Incomplete()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("ccc", c2);

    ObjectInspector oi = new ObjectInspector(this);

    try {
      oi.invokeMethod(c1, "printCheck",
        CheckResult.class, CheckResult.Incomplete());
      oi.invokeMethod(c2, "printCheck",
        CheckResult.class, CheckResult.Incomplete());
      oi.invokeMethod(c3, "printCheck",
        CheckResult.class, CheckResult.Incomplete());
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
  
  public void printCheck_Empty()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("ccc", c2);

    ObjectInspector oi = new ObjectInspector(this);

    try {
      oi.invokeMethod(c1,"printCheck",CheckResult.class,CheckResult.Empty());
      oi.invokeMethod(c2,"printCheck",CheckResult.class,CheckResult.Empty());
      oi.invokeMethod(c3,"printCheck",CheckResult.class,CheckResult.Empty());
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void printCheck_withMessage()
  {
    ConsolePrinterBase printer = new ConsolePrinterBase();
    CaseResult c1 = printer.createCaseResult("aaa", CaseResult.NULL);
    CaseResult c2 = printer.createCaseResult("bbb", c1);
    CaseResult c3 = printer.createCaseResult("ccc", c2);

    ObjectInspector oi = new ObjectInspector(this);

    try {
      CheckResult chk = CheckResult.NG();
      chk.setMessage("XXX");
      oi.invokeMethod(c1, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c2, "printCheck", CheckResult.class, chk);
      oi.invokeMethod(c3, "printCheck", CheckResult.class, chk);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
}

