/*
 * _PrinterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;
import ts.tester.coverage.ObjectWriter;
import java.io.*;

/**
 * <code>_Printer</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class _PrinterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);
      
      run(_PrinterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_PrinterNX̋@\sB");
  }

  class PrintStreamEx extends PrintStream
  {
    _PrintEvent event_ = null;

    class ObjectWriterEx extends ObjectWriter {
      @Override public void writeObject(Object o) {
        if (o != null && (o instanceof _PrintEvent)) {
          event_ = (_PrintEvent) o;
        }
      }
    }
    ObjectWriterEx objectWriter_ = new ObjectWriterEx();

    PrintStreamEx() {
      super(System.out);
      try {
        ObjectInspector oi = new ObjectInspector(_PrinterTest.this);
        oi.invokeMethod(objectWriter_, "setStreamWriter",
          OutputStreamWriter.class, new OutputStreamWriter(this));
      } catch (Exception e) {}
    }
    public void print(String s) {
      try {
        char[] cs = s.toCharArray();
        Class[] types = new Class[2];
        Object[] values = new Object[2];
        types[0] = char[].class;
        types[1] = Integer.TYPE;
        values[0] = cs;
        values[1] = cs.length;
        ObjectInspector oi = new ObjectInspector(_PrinterTest.this);
        oi.invokeMethod(objectWriter_, "writeObjectOrStream", types, values);
      } catch (Exception e) {
        NG(e);
      }
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    FALSE(printer.isStopped());
  }

  public void createCaseResult()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();

    PrintStream oldOut = System.out;
    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);

    TRUE(cr0 instanceof _CaseResult);
    EQUAL(cr0.getName(), "");
    EQUAL(cr0.getParentCaseResult(), CaseResult.NULL);
    EQUAL(psex.event_.getType(), _PrintEventType.CREATE_CASE_RESULT);
    NULL(psex.event_.getAdditional());
    _CaseIdentifier id0 = psex.event_.getCaseIdentifier();

    System.setOut(psex);
    CaseResult cr1 = printer.createCaseResult("", cr0);
    System.setOut(oldOut);

    TRUE(cr1 instanceof _CaseResult);
    EQUAL(cr1.getName(), "");
    EQUAL(cr1.getParentCaseResult(), cr0);
    EQUAL(psex.event_.getType(), _PrintEventType.CREATE_CASE_RESULT);
    EQUAL(psex.event_.getAdditional(), id0);
  }

  public void createCaseResult_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.createCaseResult(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult("", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStarted()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.testStarted(cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.TEST_STARTED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    NULL(ev.getAdditional());
  }

  public void testStarted_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStarted_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testStarted(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.testEnded(cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.TEST_ENDED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    NULL(ev.getAdditional());
  }

  public void testEnded_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testEnded(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseStarted()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.caseStarted(cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.CASE_STARTED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    NULL(ev.getAdditional());
  }

  public void caseStarted_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.caseStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseStarted_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.caseStarted(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseEnded()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.caseEnded(cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.CASE_ENDED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    NULL(ev.getAdditional());
  }

  public void caseEnded_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.caseEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseEnded_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.caseEnded(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void checkOccured()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.checkOccured(CheckResult.NG(), cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.CHECK_OCCURED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    Object obj = ev.getAdditional();
    TRUE(obj instanceof CheckResult);
    CheckResult chk = (CheckResult) obj;
    TRUE(chk.is(ResultType.NG));
  }

  public void checkOccured_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);

    try {
      printer.checkOccured(null, cr0);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.checkOccured(CheckResult.NG(), null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void checkOccured_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.checkOccured(CheckResult.KnownBug(), CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void messageNoted()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.messageNoted("", cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.MESSAGE_NOTED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    EQUAL(ev.getAdditional(), "");
  }

  public void messageNoted_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);

    try {
      printer.messageNoted(null, cr0);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.messageNoted("", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void messageNoted_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.messageNoted("", CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStopped()
  {
    MSG("ʏ̏ꍇ");

    _Printer printer = new _Printer();
    PrintStreamEx psex = new PrintStreamEx();
    PrintStream oldOut = System.out;

    System.setOut(psex);
    CaseResult cr0 = printer.createCaseResult("", CaseResult.NULL);
    System.setOut(oldOut);
    _PrintEvent ev0 = psex.event_ ;

    System.setOut(psex);
    printer.testStopped(cr0);
    System.setOut(oldOut);
    _PrintEvent ev = psex.event_ ;

    EQUAL(ev.getType(), _PrintEventType.TEST_STOPPED);
    EQUAL(ev.getCaseIdentifier(), ev0.getCaseIdentifier());
    NULL(ev.getAdditional());
  }

  public void testStopped_1()
  {
    MSG("k̏ꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testStopped(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStopped_2()
  {
    MSG("_CaseResultIuWFNgłȂꍇ");

    _Printer printer = new _Printer();

    try {
      printer.testStopped(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}
