/*
 * _PrintEventTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;

/**
 * <code>_PrintEvent</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class _PrintEventTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(_PrintEventTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_PrintEventNX̋@\sB");
  }

  /* -- test case -- */

  public void default_constructor()
  {
    MSG("ʏ̑");

    _PrintEvent event = new _PrintEvent();
    NULL(event.getType());
    NULL(event.getCaseIdentifier());
    NULL(event.getAdditional());
  }

  public void constructor_type_id()
  {
    MSG("ʏ̑");

    _CaseIdentifier id = new _CaseIdentifier();
    _PrintEvent event = new _PrintEvent(_PrintEventType.TEST_ENDED, id);
    EQUAL(event.getType(), _PrintEventType.TEST_ENDED);
    EQUAL(event.getCaseIdentifier(), id);
    NULL(event.getAdditional());
  }

  public void constructor_type_id_1()
  {
    MSG("k̏ꍇ");

    _CaseIdentifier id = new _CaseIdentifier();
    try {
      _PrintEvent event = new _PrintEvent(null, id);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      _PrintEvent event = new _PrintEvent(_PrintEventType.TEST_ENDED, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_type_id_added()
  {
    MSG("ʏ̑");

    _CaseIdentifier id = new _CaseIdentifier();
    _PrintEvent event = new _PrintEvent(_PrintEventType.TEST_ENDED, id, "");
    EQUAL(event.getType(), _PrintEventType.TEST_ENDED);
    EQUAL(event.getCaseIdentifier(), id);
    EQUAL(event.getAdditional(), "");
  }

  public void constructor_type_id_added_1()
  {
    MSG("k̏ꍇ");
    _CaseIdentifier id = new _CaseIdentifier();
    try {
      _PrintEvent event = new _PrintEvent(null, id, "a");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      _PrintEvent event = new _PrintEvent(_PrintEventType.TEST_ENDED,null,"a");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      _PrintEvent event = new _PrintEvent(_PrintEventType.TEST_ENDED,id,null);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
}
