/*
 * _CaseResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;
import ts.tester.util.*;

/**
 * <code>_CaseResult</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class _CaseResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);
      
      run(_CaseResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_CaseResultNX̋@\sB");
  }

  /* -- test case -- */

  public void constructor_name_parent()
  {
    MSG("ʏ̑");

    _CaseResult r = new _CaseResult("abc", CaseResult.NULL);
    EQUAL(r.getName(), "abc");
    EQUAL(r.getMessage(), "");
    EQUAL(r.getParentCaseResult(), CaseResult.NULL);
    EQUAL(r.count(ResultType.OK), 0);
    NOTNULL(r.getId());

    _CaseResult r2 = new _CaseResult("def", r);
    EQUAL(r2.getName(), "def");
    EQUAL(r2.getMessage(), "");
    EQUAL(r2.getParentCaseResult(), r);
    EQUAL(r2.count(ResultType.OK), 0);
    NOTNULL(r2.getId());
  }

  public void addChildResult()
  {
    _CaseResult r = new _CaseResult("abc", CaseResult.NULL);
    EQUAL(r.getName(), "abc");
    EQUAL(r.getMessage(), "");
    EQUAL(r.getParentCaseResult(), CaseResult.NULL);
    EQUAL(r.count(ResultType.OK), 0);
    NOTNULL(r.getId());

    r.addChildResult(CheckResult.OK());
    EQUAL(r.getName(), "abc");
    EQUAL(r.getMessage(), "");
    EQUAL(r.getParentCaseResult(), CaseResult.NULL);
    EQUAL(r.count(ResultType.OK), 1);
    NOTNULL(r.getId());
  }
}
