/*
 * PassResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>PassResult</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class PassResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(PassResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    PassResult<Integer> lineCoverage = new PassResult<Integer>();
    NOTNULL(lineCoverage);
    EQUAL(lineCoverage.countAllResults(), 0);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(0), false);
    EQUAL(lineCoverage.containsKeyOfResult(1), false);
    EQUAL(lineCoverage.containsKeyOfResult(2), false);
    EQUAL(lineCoverage.getPassCountOfResult(0), 0);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 0);
    FALSE(lineCoverage.enumAllResultKeys().hasMoreElements());
    FALSE(lineCoverage.enumPassedResultKeys().hasMoreElements());
    FALSE(lineCoverage.enumNotPassedResultKeys().hasMoreElements());
  }

  public void addResult()
  {
    PassResult<Integer> lineCoverage = new PassResult<Integer>();
    lineCoverage.addResult(2);
    lineCoverage.addResult(1);
    lineCoverage.addResult(4);
    lineCoverage.addResult(3);
    EQUAL(lineCoverage.countAllResults(), 4);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(1), true);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), true);
    EQUAL(lineCoverage.containsKeyOfResult(5), false);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 0);
    EQUAL(lineCoverage.getPassCountOfResult(3), 0);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);
    EQUAL(lineCoverage.getPassCountOfResult(5), 0);

    Enumeration<Integer> e0 = lineCoverage.enumAllResultKeys();
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 1);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 2);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 3);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 4);
    FALSE(e0.hasMoreElements());
  }

  public void addResult_0()
  {
    MSG("k̏ꍇ");

    PassResult<Integer> pr = new PassResult<Integer>();
    try {
      pr.addResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addResult_1()
  {
    MSG("s𕡐ǉꍇ");

    PassResult<Integer> lineCoverage = new PassResult<Integer>();
    lineCoverage.addResult(2);
    lineCoverage.addResult(1);
    lineCoverage.addResult(4);
    lineCoverage.addResult(3);
    EQUAL(lineCoverage.countAllResults(), 4);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(1), true);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), true);
    EQUAL(lineCoverage.containsKeyOfResult(5), false);

    lineCoverage.addResult(4);
    EQUAL(lineCoverage.countAllResults(), 4);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(1), true);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), true);
    EQUAL(lineCoverage.containsKeyOfResult(5), false);

    lineCoverage.addResult(2);
    EQUAL(lineCoverage.countAllResults(), 4);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(1), true);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), true);
    EQUAL(lineCoverage.containsKeyOfResult(5), false);
  }

  public void incrementPassCountOfResult()
  {
    PassResult<Integer> lineCoverage = new PassResult<Integer>();
    lineCoverage.addResult(4);
    lineCoverage.addResult(1);
    lineCoverage.addResult(3);
    lineCoverage.addResult(2);

    lineCoverage.incrementPassCountOfResult(1);
    lineCoverage.incrementPassCountOfResult(3);
    lineCoverage.incrementPassCountOfResult(1);
    lineCoverage.incrementPassCountOfResult(1);

    EQUAL(lineCoverage.countAllResults(), 4);
    EQUAL(lineCoverage.countPassedResults(), 2);
    EQUAL(lineCoverage.passedRatio(), 0.5f);
    EQUAL(lineCoverage.containsKeyOfResult(1), true);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), true);
    EQUAL(lineCoverage.getPassCountOfResult(1), 3);
    EQUAL(lineCoverage.getPassCountOfResult(2), 0);
    EQUAL(lineCoverage.getPassCountOfResult(3), 1);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);

    Enumeration<Integer> e0 = lineCoverage.enumAllResultKeys();
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 1);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 2);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 3);
    TRUE(e0.hasMoreElements());
    EQUAL(e0.nextElement().intValue(), 4);
    FALSE(e0.hasMoreElements());

    Enumeration<Integer> e1 = lineCoverage.enumPassedResultKeys();
    TRUE(e1.hasMoreElements());
    EQUAL(e1.nextElement().intValue(), 1);
    TRUE(e1.hasMoreElements());
    EQUAL(e1.nextElement().intValue(), 3);
    FALSE(e1.hasMoreElements());

    Enumeration<Integer> e2 = lineCoverage.enumNotPassedResultKeys();
    TRUE(e2.hasMoreElements());
    EQUAL(e2.nextElement().intValue(), 2);
    TRUE(e2.hasMoreElements());
    EQUAL(e2.nextElement().intValue(), 4);
    FALSE(e2.hasMoreElements());
  }

  public void incrementPassCountOfResult_0()
  {
    MSG("k̏ꍇ");

    PassResult<Integer> pr = new PassResult<Integer>();
    try {
      pr.incrementPassCountOfResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void incrementPassCountOfResult_1()
  {
    MSG("݂Ȃsɑ΂Ďsꍇ");

    PassResult<Integer> lineCoverage = new PassResult<Integer>();
    lineCoverage.addResult(3);
    lineCoverage.addResult(2);

    EQUAL(lineCoverage.countAllResults(), 2);
    EQUAL(lineCoverage.countPassedResults(), 0);
    EQUAL(lineCoverage.passedRatio(), 0.0f);
    EQUAL(lineCoverage.containsKeyOfResult(1), false);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), false);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 0);
    EQUAL(lineCoverage.getPassCountOfResult(3), 0);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);

    lineCoverage.incrementPassCountOfResult(2);
    EQUAL(lineCoverage.countAllResults(), 2);
    EQUAL(lineCoverage.countPassedResults(), 1);
    EQUAL(lineCoverage.passedRatio(), 0.5f);
    EQUAL(lineCoverage.containsKeyOfResult(1), false);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), false);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 1);
    EQUAL(lineCoverage.getPassCountOfResult(3), 0);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);

    lineCoverage.incrementPassCountOfResult(1);
    EQUAL(lineCoverage.countAllResults(), 2);
    EQUAL(lineCoverage.countPassedResults(), 1);
    EQUAL(lineCoverage.passedRatio(), 0.5f);
    EQUAL(lineCoverage.containsKeyOfResult(1), false);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), false);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 1);
    EQUAL(lineCoverage.getPassCountOfResult(3), 0);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);

    lineCoverage.incrementPassCountOfResult(4);
    EQUAL(lineCoverage.countAllResults(), 2);
    EQUAL(lineCoverage.countPassedResults(), 1);
    EQUAL(lineCoverage.passedRatio(), 0.5f);
    EQUAL(lineCoverage.containsKeyOfResult(1), false);
    EQUAL(lineCoverage.containsKeyOfResult(2), true);
    EQUAL(lineCoverage.containsKeyOfResult(3), true);
    EQUAL(lineCoverage.containsKeyOfResult(4), false);
    EQUAL(lineCoverage.getPassCountOfResult(1), 0);
    EQUAL(lineCoverage.getPassCountOfResult(2), 1);
    EQUAL(lineCoverage.getPassCountOfResult(3), 0);
    EQUAL(lineCoverage.getPassCountOfResult(4), 0);
  }
}
