/*
 * TesterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * <code>Tester</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class TesterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(TesterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner classes -- */

  static class TesterEx extends Tester
  {
    @Override
    protected void initTesting()
    {}

    // --> Compile error
    //u\bh͂̃X[p[NX̃\bhI[o[Ch܂Bv
    //@Override
    //public void initTest()
    //{}

    @Override
    protected void preTesting()
    {}

    // --> Compile error:
    //u\bh͂̃X[p[NX̃\bhI[o[Ch܂Bv
    //@Override
    //public void preTest()
    //{}

    @Override
    protected void initInvocation(String methodName)
    {}

    @Override
    protected void preInvocation(String methodName)
    {}

    @Override
    protected void postInvocation(String methodName)
    {}

    @Override
    protected void endInvocation(String methodName)
    {}

    @Override
    protected void postTesting()
    {}

    @Override
    protected void endTesting()
    {}

    @Override
    protected void stopTesting(Exception e) throws Exception {
      System.out.println("!! Stopped !! -> " + String.valueOf(e));
      super.stopTesting(e);
    }

    public void a() { System.out.println("== a =="); }
    public void b() { System.out.println("== b =="); } 

    protected void c() { System.out.println("*** bad c ***"); }
    private void d() { System.out.println("*** bad d ***"); }

    public void a(String aa) { System.err.println("*** bad a ***"); }
    public int b(int bb) { System.err.println("*** bad b ***"); return 0; }
    public void e(int ee) { System.out.println("*** bad e ***"); }
    public int f() { System.out.println("*** bad f ***");  return 0; }

    static boolean causeError_ = false;
    public void g() {
      System.out.println("== g ==");
      if (! causeError_) return;
      causeError_ = false;
      throw new NumberFormatException();
    }
  }

  class TesterExEx extends TesterEx {
    public void h() {};
  }

  /* -- test case -- */

  public void instanciation()
  {
    MSG("ftHgRXgN^̊mF");

    TesterEx ins = new TesterEx();
    NOTNULL(ins);
  }

  public void stopTesting_Exception()
  {
    MSG("ftHgRXgN^̊mF");

    TesterEx tester = new TesterEx();
    try {
      tester.stopTesting(new NumberFormatException());
      NG();
    } catch (NumberFormatException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void stopTesting_Exception_1()
  {
    MSG("k̏ꍇ");

    TesterEx tester = new TesterEx();
    try {
      tester.stopTesting(null);
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_tester_methodName()
  {
    MSG("ʏ̑̏ꍇ");

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, "a");
      Tester.run(tester, "b");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_tester_methodName_1()
  {
    MSG("sIuWFNgk̏ꍇ");

    try {
      TesterEx tester = new TesterEx();
      Tester.run((Tester)null, "a");
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      Tester.run((Tester) null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_tester_methodName_2()
  {
    MSG("P[X\bhk̏ꍇ");

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, null);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_tester_methodName_3()
  {
    MSG("P[X\bhsȏꍇ");

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, "c");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, "d");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, "e");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      Tester.run(tester, "f");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_tester_methodName_4()
  {
    MSG("\bh̎sɗOX[ꂽꍇ");
    try {
      TesterEx tester = new TesterEx();
      tester.causeError_ = true;
      Tester.run(tester, "g");
      NG();
    } catch (NumberFormatException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName()
  {
    MSG("ʏ̑̏ꍇ");

    try {
      Tester.run(TesterEx.class, "a");
      Tester.run(TesterEx.class, "b");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName_1()
  {
    MSG("sNX̃CX^XɎsꍇ");

    try {
      TesterExEx tester = new TesterExEx();
      Tester.run(tester, "h");
      OK();
    } catch (Exception e) {
      NG(e);
    }

    try {
      Tester.run(TesterExEx.class, "h");
      NG();
    } catch (InstantiationException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName_2()
  {
    MSG("sNXk̏ꍇ");

    try {
      Tester.run((Class<Tester>) null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      Tester.run((Class<Tester>)null, "a");
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName_3()
  {
    MSG("P[X\bhk̏ꍇ");

    try {
      Tester.run(TesterEx.class, null);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName_4()
  {
    MSG("P[X\bhsȏꍇ");

    try {
      Tester.run(TesterEx.class, "c");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      Tester.run(TesterEx.class, "d");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      Tester.run(TesterEx.class, "e");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      Tester.run(TesterEx.class, "f");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void run_testerClass_methodName_5()
  {
    MSG("\bh̎sɗOX[ꂽꍇ");
    try {
      TesterEx.causeError_ = true;
      Tester.run(TesterEx.class, "g");
      NG();
    } catch (NumberFormatException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}
