<?php
/**
 * Extended Pagination Helper class file.
 */
App::import('Helper', 'Paginator');
class PaginatorExHelper extends PaginatorHelper {

	var $helpers = array('Html');
	var $options = array();

	function sortAllow($title, $key = null, $options = array()) {
		$options = array_merge(array('url' => array(), 'model' => null), $options);

		if (empty($key)) {
			$key = $title;
			$title = __(Inflector::humanize(preg_replace('/_id$/', '', $title)), true);
		}

		$sortKey = parent::sortKey($options['model']);
		$defaultModel = parent::defaultModel();
		$isSorted = (
			$sortKey === $key || 
			$sortKey === $defaultModel . '.' . $key ||
			$key === $defaultModel . '.' . $sortKey
		);

		if (!$isSorted) {
			$dir = parent::sortDir($options['model']) === 'asc' ? 'desc' : 'asc';
		} else {
			$dir = isset($options['direction']) ? $options['direction'] : 'asc';
		}

		if (!empty($options['class'])) {
			$options['class'] .= ' ' . $dir. '_allow';
		} else {
			$options['class'] = $dir. '_allow';
		}

		return parent::sort($title, $key, $options);
	}

}
