<?php
/* 
 * 管理権限表示用Helper
 */
class GroupHelper extends Helper {
	var $helpers = array(
		'Html',
		'Form'
	);

	var $full_groups = array();
	var $groups = array();

	function __construct()
	{
		$this->full_groups = array(
			Configure::read('Group.admin') => __('Super Administrator', true),
			Configure::read('Group.subadmin') => __('Vice-Administrator', true),
//			Configure::read('Group.watcher') => __('Watcher', true),
			Configure::read('Group.member') => __('User', true),
			Configure::read('Group.locked') => __('Locked', true),
			Configure::read('Group.deleted') => __('Banned', true),
		);

		$this->groups = array(
			Configure::read('Group.subadmin') => __('Vice-Administrator', true),
//			Configure::read('Group.watcher') => __('Watcher', true),
			Configure::read('Group.member') => __('User', true),
		);
	}

	function get_name4group_id($group_id)
	{
		if (empty($group_id)) {
			return null;
		}

		if (isset($this->full_groups[$group_id])) {
			return $this->full_groups[$group_id];
		} else {
			return null;
		}
	}


	function create_group_select($fieldName = 'group_id', $options = array('type' => 'select', 'default' => ''))
	{
		if (!isset($options['type'])) {
			$options['type'] = 'select';
		}

		if (!isset($options['default']) || empty($options['default'])) {
			$options['default'] = Configure::read('Group.member');
		}

		$options['options'] = $this->groups;
		return $this->Form->input($fieldName, $options);
	}
}

