<?php 
if (!isset($keywords)) {
	$keywords = null;
}
?>
<div class="users listview">
<div class="box full">
<div class="boxHeader"><h2>
<span><?php __('Users List'); ?><?php if (!empty($keywords)): ?><?php __('Search Result'); ?><?php endif; ?></span>
<?php 
$url = array('action' => 'search');
if ($isAdmin) {
	$url['prefix'] = Configure::read('Routing.prefixes');
} else {
	$url['prefix'] = null;
}
echo $this->element('searchbox',
	array(
		'url' => $url,
		'noIcon' => false,
		'keywords' => $keywords,
	)
);
?>
</h2></div>
<div class="boxBody">
<p>
<?php
$pagenator_options = array();
if (isset($searchwords)) {
	$pagenator_options['url'] = array('?' => 
		array('keyword' => $searchwords['keywords']),
	);

	$paginator->options(array('url' => array_merge($this->passedArgs, $pagenator_options['url'])));
} else {
	$paginator->options(array('url' => $this->passedArgs));
}

echo $paginator->counter(array(
	'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?></p>

<div class="paging">
	<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $paginator->numbers();?> | 
	<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

<table cellpadding="0" cellspacing="0"<?php if ($isAdmin): ?> class="2rows"<?php endif ?>>
<tr>
	<th><?php echo $paginatorEx->sortAllow(__('No.', true), 'id', $pagenator_options); ?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Name', true), 'name', $pagenator_options);?></th>
<?php if ($isAdmin): ?>
	<th><?php echo $paginatorEx->sortAllow(__('Group', true), 'group_id', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Last Login', true), 'modified', $pagenator_options);?></th>
<?php endif; ?>
	<th><span class="NoSortTh"><?php echo __('Characters'); ?></span></th>
<?php if ($isAdmin): ?>
	<th><?php echo $paginatorEx->sortAllow(__('UserId', true), 'username', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('URL', true), 'url', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Pc Mail', true), 'pcmail', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Registed', true), 'created', $pagenator_options);?></th>
<?php endif; ?>
</tr>
<?php
$i = 0;
foreach ($users as $user):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
<tr<?php echo $class;?>>
<td<?php if ($isAdmin): ?> rowspan="2"<?php endif ?>>
	<?php echo $user['User']['id']; ?>
</td>
<td>
	<?php echo $html->link($text->truncate($user['User']['name'], 16), array('action' => 'view', $user['User']['id']), array('escape' => false), false); ?>
</td>
<?php if ($isAdmin): ?>
<td>
	<?php echo $group->get_name4group_id($user['User']['group_id']); ?>
</td>
<td class="lastAccess">
<?php
	echo $time->niceShort($user['User']['modified'], array('format' => 'Y/m/d H:i')); 
?>
</td>
<?php endif; ?>
<td class="characterList" nowrap>
<?php
if (!empty($user['Character'])) {
	foreach ($user['Character'] as $v) {
		$picture = $this->element('character_picture_image', array(
			'basename' => $v['main_picture'],
			'options' => array(
				'previewVersion' => 'xs',
				'class' => 'shadow',
				'url' => array('controller' => 'characters', 'action' => 'view', $v['id']),
				'alternative' => $text->truncate($v['name'], 32),
			)
		));

		echo $html->tag('span', $picture, array('class' => 'image'));
	}

	echo $html->div('total_chara_num',
		$html->link(
			sprintf(__('Total %d Characters', true), $user['User']['character_num']),
			$url = array('controller' => 'characters', 'action' => 'index', $user['User']['id'])
		)
	);
}
?>
</td>
<?php if ($isAdmin): ?>
<td>
	<?php echo $user['User']['username']; ?>
</td>
<td>
<?php if (!empty($user['User']['url'])): ?>
	<?php echo $html->link('HOME', 
		$user['User']['url'],
		array(
			'target' => '_blank',
			'title' => $user['User']['url'],
		)
	); ?>
<?php endif; ?>
</td>
<td>
	<?php echo $html->link($user['User']['pcmail'], "mailto:".$user['User']['pcmail']); ?>
</td>
<td class="modified">
	<?php echo $time->niceShort($user['User']['created'], array('format' => 'Y/m/d H:i')); ?>
</td>
<?php endif; ?>
</tr>
<?php if ($isAdmin): ?>
<tr>
<td class="notes"<?php if ($isAdmin): ?> colspan="8"<?php endif; ?>>
	<div><?php echo $user['User']['notes']; ?></div>
	<div class="UserAgent"><?php 
		if (strrpos($user['User']['useragent'], 'MSIE') !== false) {
			echo $text->highlight($user['User']['useragent'], 'MSIE');
} elseif (strpos($user['User']['useragent'], 'Firefox') !== false) {
			echo $text->highlight($user['User']['useragent'], 'Firefox');
		} elseif (strpos($user['User']['useragent'], 'Chrome') !== false) {
			echo $text->highlight($user['User']['useragent'], 'Chrome');
		} elseif (strpos($user['User']['useragent'], 'Safari') !== false) {
			echo $text->highlight($user['User']['useragent'], 'Safari');
		} elseif (strpos($user['User']['useragent'], 'Opera') !== false) {
			echo $text->highlight($user['User']['useragent'], 'Opera');
		} else {
			echo $user['User']['useragent'], 44;
		}
	 ?></div>
	<div class="Host"><?php echo $user['User']['host']; ?></div>
</td>
</tr>
<?php endif; ?>
<?php endforeach; ?>
</table>
</div>
<div class="paging">
	<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $paginator->numbers();?> | 
	<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

</div>
</div>

</div>