<div class="systems view">

<div class="system_data">
<?php
	$header = $system['System']['name'];
?>
<?php if ($isAdmin): ?>
<?php
	$header .= $html->tag('span', 
		$select->get_i18n_public_flag($system['System']['public_flag'], $public_flags),
		array(
			'class' => 'text publicFlag',
		)
	);
/*	if ($system['System']['set_npc']) {
		$npc_status = __('NPC Setting: Use', true);
	} else {
		$npc_status = __('NPC Setting: No Use', true);
	}
	$header .= $html->tag('span', 
		$npc_status,
		array(
			'class' => 'text',
		)
	);*/

	$header .= $html->tag('span',
			'['. $html->link(__('Edit', true), array(
				'action' => 'edit', $system['System']['id']
				)
			). ']'
		).
		$html->tag('span',
			'['. $html->link(__('Delete', true), array(
				'action' => 'delete', $system['System']['id']
				)
			). ']'
		);
?>
<?php endif; ?>

<?php
	/* Body */
	// システム説明
	$body = $html->div('', 
		$system['System']['detail'], array(
			'id' => 'SystemDetail',
	));

	// SyStem画像：公式URL
	$url = '';
	$official_link = '';
	if ($system['System']['url']) {
		$url = $system['System']['url'];
		$official_link .= sprintf('<div id="OfficialWeb">%s : %s</div>',
			__('Official Web Site', true),
			$html->link($url,
				$url,
				array('target'=>'_blank', 'escape' => false),
				false
			)
		);
	}
	$body .= $official_link;

	$file = $upfile->file(
		'l', 
		CorePlus::get_value($system, 'Attachment.0'),
		array(
			'model_name' => 'System', 
			'mime_type' => 'original',
		)
	);
	$system_img = $upfile->embed(
		$file,
		array(
			'linkTo' => $url,
			'alt' => CorePlus::get_value($system, 'Attachment.0.alternative'),
			'restrict' => array('image'),
			'htmlAttributes' => array(
				'target' => '_blank',
			),
		)
	);
	if (!empty($system_img)) {
		$body = $html->tag('table', $html->tableCells(array(
			$system_img,
			$body
		)));
	}


	// Information
	$body .= $html->div('', 
		'',
		array(
			'id' => 'systemInformation'
		)
	);

	// InsertHTML
	$body .= $html->div('InsertHtml',
		$system['System']['ad']
	);

	$footer = '';
	// CopyRight
	$footer .= $html->tag('div',
		$system['System']['copyright']
	);

	echo $this->element('box', array(
		'header' => $header,
		'body' => $body,
		'footer' => $footer,
	));
?>
</div>


<div class="characters">
<?php
	$total =  $html->tag('span', sprintf(__('Total Characters %d', true), $system['System']['character_num']), array('class' => 'total_chara_num'));

	echo $this->element('character_picture_table', array(
		'header' => __('Characters', true). $total,
		'characters' => $system['Character'],
		'previewVersion' => 'xs',
		'colNum' => 15,
		'id' => null,
		'isUser' => false,
		'isCharacter' => false,
		'isSystem' => false,
		'isModified' => false,
		'more_url' => array(
			'controller' => 'characters', 
			'action' => 'index',
			'system:'.$system['System']['id'],
		),
	));
?>
</div>

<div class="character_sheets">
<?php 
	$header =  __('CharacterSheets', true).
		$html->tag(
			'span',
			$html->link(
				__(' ...More', true),
				array(
					'controller' => 'character_sheets',
					'action' => 'index',
					$system['System']['id'],
				)
			),
			array(
				'class' => 'link',
			)
		);
	$header .= $html->tag(
			'span',
			$html->link(
				__('New CharacterSheet', true),
				array(
					'controller' => 'character_sheets',
					'action' => 'add',
					$system['System']['id'],
				)
			),
			array(
				'class' => 'link',
			)
		);

	$body = '';
	if (isset($system['CharacterSheet'])) {
		foreach($system['CharacterSheet'] as $characterSheet) {
			if ($isAdmin) {
				$characterSheet['name'] = $html->link($characterSheet['name'], 
					array(
						'controller' => 'character_sheets',
						'action' => 'view',
						$characterSheet['id'],
					), array('escape' => false), false
				);
			}

			$sheet = $characterSheet['name'];
			$body .= $html->tag(
				'span',
				$sheet,
				array(
					'class' => 'characterSheet',
				)
			);
		}
	}

	$footer = null;

	echo $this->element('box', array(
		'header' =>$header,
		'body' => $body,
		'footer' => $footer,
	));
 ?>
</div>

<?php if ($isAdmin && (empty($site_configs['System.otherSetting']['value']) || $site_configs['System.otherSetting']['value'] != $system['System']['id'])) : ?>
<div class="profiles">
<div class="box">
<div class="boxHeader"><h3>
<?php
	__('Profiles');

	echo $html->tag('span',
		"[".$html->link(__('New Profile', true), 
			array('controller' => 'profiles', 'action' => 'add', $system['System']['id']),
			array(
				'class' => 'link',
			)
		)."]"
	);
?>
<?php if (empty($system['Profile'])): ?>
<?php
	echo $html->tag('span',
		"[".$html->link(__('Import', true), 
			array('controller' => 'profiles', 'action' => 'import_profiles', $system['System']['id']),
			array(
				'class' => 'link',
			)
		)."]"
	);
?>
<?php else: ?>
<?php
	echo $html->tag('span',
		"[".$html->link(__('Export', true), 
			array('controller' => 'profiles', 'action' => 'export_profiles', $system['System']['id']),
			array(
				'class' => 'link',
			)
		)."]"
	);
?>
<?php endif; ?>
</h3></div>
<div>
<?php echo $form->create('Profile', array('url' => array(
	'controller' => 'profiles',
	'action' => 'admin_edit_all',
	$system['System']['id']
)));?>
<table class="CharacterSheet">
<tr>
<th>Id</th>
<th>
	<?php echo __('Order');?>
</th>
<th colspan="6">
	<?php echo __('Detail');?>
</th>
</tr>
<?php
$i = 0;
foreach ($system['Profile'] as $profile):
	$class = null;
	$profiledisp->set_profile_type4view($profile);
?>
<tr>
<td rowspan="<?php if ($profiledisp->profile_type['is_subsetting']): ?>4<?php else: ?>3<?php endif; ?>">
	<?php echo $profile['id']; ?>
</td>
<td rowspan="<?php if ($profiledisp->profile_type['is_subsetting']): ?>4<?php else: ?>3<?php endif; ?>">
<?php
	echo $form->input($profile['id'].'.sort_order', array(
		'type' => 'text',
		'label' => false,
		'style' => 'ime-mode:inactive;',
		'value' => $profile['sort_order'],
		'class' => 'editAll',
	));
?>
</td>

<th>
	<?php echo __('Item Name', true);?>
</th>
<th>
	<?php echo __('Key Name', true);?>
</th>
<th>
	<?php echo __('Profile Type', true);?>
</th>
<th>
	<?php echo __('Required', true);?>
</th>
<th>
	<?php echo __('Show List', true);?>
</th>
<th>
	<?php echo __('Search Target', true);?>
</th>
</tr>
<tr>
<td>
	<?php echo $profile['name']; ?>
</td>
<td>
	<?php echo $profile['key_name']; ?>
</td>
<td>
<?php 
	$profile_type = $profiledisp->get_i18n_profile_type($profile['profile_type'], $profile_types);
	echo $profile_type;
?>
</td>
<td class="boolean">
<?php
	echo $select->create_boolean_select($profile['id'].'.required', array('default' => $profile['required']));
?>
</td>
<td class="boolean">
<?php
	if ($profile['profile_type'] == 'table' || $profile['profile_type'] == 's-table') {
		$options =  array(
			false => __('OFF' ,true),
		);
	} else {
		$options =  array(
			true => __('ON' ,true),
			false => __('OFF' ,true),
		);
	}
	echo $select->create_boolean_select($profile['id'].'.show_list', array('default' => $profile['show_list'], 'options' => $options));
?>
</td>
<td class="boolean">
<?php
	echo $select->create_boolean_select($profile['id'].'.search', array('default' => $profile['search']));
?>
</td>
</tr>
<tr>
<td colspan="6" class="edit<?php if ($profiledisp->profile_type['is_table']): ?> table<?php endif; ?>">
<?php 
	if ($profile['profile_type'] == 's-table') {
		if (isset($profile['ProfileTable'][0]['ProfileTableStatic'])) {
			$rows = count($profile['ProfileTable'][0]['ProfileTableStatic']);
		} else {
			$rows = 2;
		}
	} else {
		$rows = 2;
	}
	$profiledisp->disp_forms4profile_type($profile, $rows, 0);
?>
</td>
</tr>
<tr>
<td colspan="8" class="actions">
<?php if ($profiledisp->profile_type['is_select'] || $profiledisp->profile_type['is_radio'] || $profiledisp->profile_type['is_checkbox']): ?> 
<?php 
	echo $html->link(
		__('Edit Items', true), 
		array('controller' => 'profile_selects', 'action' => 'admin_listview', $profile['id'])
	);
?>
<?php endif; ?>
<?php if ($profiledisp->profile_type['is_table']): ?> 
<?php
	echo $html->link(
		__('Edit Table', true), 
		array('controller' => 'profile_tables', 'action' => 'admin_listview', $profile['id'])
	);
?>
<?php endif; ?>
<?php
	echo $html->link(
		__('Edit', true), 
		array('controller' => 'profiles', 'action' => 'edit', $profile['id'])
	);
	echo $html->link(
		__('Delete', true), 
		array('controller' => 'profiles', 'action' => 'delete', $profile['id']), null, sprintf(__('Are you sure you want to delete # %s?', true), $profile['name'])
	);
?>
</td>
</tr>
<?php endforeach; ?>
</table>
<?php	echo $token->create(); ?>
<?php echo $form->end(__('Edit All', true));?>
</div>

<div class="boxFooter">
<div class="actions">
<ul>
<li><?php echo $html->link(__('New Profile', true), array('controller' => 'profiles', 'action' => 'add', $system['System']['id'])); ?></li>
<li>
<?php if (empty($system['Profile'])): ?>
<?php
	echo $html->link(__('Import', true), 
		array('controller' => 'profiles', 'action' => 'import_profiles', $system['System']['id']),
		array(
			'class' => 'link',
		)
	);
?>
<?php else: ?>
<?php
	echo $html->link(__('Export', true), 
		array('controller' => 'profiles', 'action' => 'export_profiles', $system['System']['id']),
		array(
			'class' => 'link',
		)
	);
?>
<?php endif; ?>
</li>
</ul>
</div>
<?php // echo $html->div('', ' * '. __('Import is available only No Profiles.', true)); ?>
</div>
</div>
</div>
<?php endif; ?>

</div>