<?php
/**
 * ファイルアップロードフォーム
 * Attachmentエレメントのカスタマイズ版
 * ファイルアップロード済みの場合、追加アップロードフォームを表示しない
 */

// アップロード済みファイルの表示サイズ
if (!isset($previewVersion)) {
	$previewVersion = 'l';
}

/* Set $assocAlias and $model if you're using this element multiple times in one form */

if (!isset($assocAlias)) {
	$assocAlias = 'Attachment';
} else {
	$assocAlias = Inflector::singularize($assocAlias);
}

if (!isset($model)) {
	$model = $form->model();
}

$modelId = $form->value($form->model().'.id');

if (isset($this->data[$assocAlias][0]['basename'])) {
	array_unshift($this->data[$assocAlias], array());
}

if (!isset($label)) {
	$label = __('File', true);
}

?>
<div class="attachments element">
<?php if (!isset($this->data[$assocAlias][1]['id']) || isset($this->data[$assocAlias][0]['file'])): ?>
<!-- New Attachment -->
<div class="new">
<?php
	echo $form->hidden($assocAlias . '.0.model', array('value' => $model));
	echo $form->hidden($assocAlias . '.0.group', array('value' => strtolower($assocAlias)));
	echo $form->input($assocAlias . '.0.file', array(
		'label' => $label,
		'type'  => 'file',
	));
	echo $form->input($assocAlias . '.0.alternative', array(
		'label' => $label." ".__('Caption', true),
		'value' => '',
	));
?>
</div>
<?php else: ?>
<!-- Existing Attachments -->
<div class="existing">
<div>
<?php
	$i = 1;
	$item = $this->data[$assocAlias][$i];

	echo $form->hidden($assocAlias . '.' . $i . '.id', array('value' => $item['id']));

	$file = $upfile->file(
		$previewVersion, 
		CorePlus::get_value($this->data, $assocAlias.'.'.$i),
		array(
			'model_name' => $model, 
			'mime_type' => 'original',
			'nodata' => 'image',
		)
	);

	echo $upfile->embed(
		$file,
		array(
			'alt' => CorePlus::get_value($user, 'User.name'),
			'class' => 'shadow',
			'id' => 'HomeUserImage',
			'restrict' => array('image')
		)
	);

	// ファイル情報出力
	echo $upfile->fileInfo($file, $item);

	// caption
	echo $form->input($assocAlias . '.' . $i . '.alternative', array(
		'label' => __('Caption', true),
		'value' => $item['alternative'],
	));

	// Release
	if (isset($item['delete']) && $item['delete'] == 1) {
		$checked = 'checked';
	} else {
		$checked = null;
	}
	echo $form->input($assocAlias . '.' . $i . '.delete', array(
		'label' => __('Release', true),
		'type' => 'checkbox',
		'value' => 0,
		'checked' => $checked,
	));
?>
</div>
</div>
<?php endif ?>
</div>