<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class User extends AppModel {

	var $name = 'User';
	var $belongsTo = array('Group');

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $hasMany = array(
		// ユーザ画像
		'Attachment' => array(
			'className' => 'Media.AttachmentEx',
			'foreignKey' => 'foreign_key',
			'dependent' => true,
			'conditions' => array('Attachment.model' => 'User'),
			'fields' => array(
				'Attachment.id',
				'Attachment.user_id',
				'Attachment.foreign_key',
				'Attachment.dirname',
				'Attachment.basename',
				'Attachment.alternative',
				'Attachment.size',
				'Attachment.created',
			),
			'dependent' => true,
			'order' => '',
			'limit' => '',
			'offset' => '',
		),
		'Character' => array(
			'className' => 'Character',
			'foreignKey' => 'user_id',
			'dependent' => false,
			'conditions' => array(
				'Character.public_flag' => 'public',
				'Character.deleted' => '0',
			),
			'fields' => array(
				'Character.id',
				'Character.system_id',
				'Character.user_id',
				'Character.name',
				'Character.main_picture',
				'Character.public_flag',
				'Character.status',
				'Character.modified',
			),
			'order' => array(
				'Character.modified' => 'DESC',
			),
			'limit' => '5',
			'offset' => '',
		),
		'CharacterSheet' => array(
			'className' => 'CharacterSheet',
			'foreignKey' => 'user_id',
			'dependent' => false,
			'conditions' => array(
				'CharacterSheet.public_flag' => 'public',
			),
			'fields' => array(
				'CharacterSheet.id',
				'CharacterSheet.system_id',
				'CharacterSheet.key_name',
				'CharacterSheet.name',
				'CharacterSheet.public_flag',
				'CharacterSheet.modified',
			),
			'order' => array(
				'CharacterSheet.modified' => 'DESC',
			),
			'limit' => '5',
			'offset' => '',
		)
	);

	var $fields = array(
		'add' => array('group_id', 'name', 'username', 'password', 'useragent', 'host'),
		'edit' => array('name', 'url', 'notes'),
		'escape' => array(
			'name' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
			'url' => array(
				'url' => array(
					'rule' => array('url', true),
					'allowEmpty' => true,
				),
			),
			'notes' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
		),
	);

	var $validate = array(
		'name' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'username' => array(
			'isUnique' => array(
				'rule' => array('isUnique'),
			),
			'betweenWrapper' => array(
				'rule' => array('betweenUsername'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password1' => array(
			'betweenWrapper' => array(
				'rule' => array('betweenPassword'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password2' => array(
			'compare2fields' => array(
				'rule' => array('compare2fields', 'password1', false),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'pcmail' => array(
			'isUniquePcMail' => array(
				'rule' => array('isUniquePcMail'),
			),
			'isPcMail' => array(
				'rule' => array('isPcMail'),
			),
		),
	);

	/* コールバックメソッド */
	function beforeValidate($options = array())
	{

		return parent::beforeValidate($options);

	}
	function beforeSave($options = array())
	{
		$result = parent::beforeSave($options);
		if ($result === false) {
			return $result;
		}

		// textarea
		if (!empty($this->data['User']['notes'])) {
			$this->data['User']['notes'] = str_replace(array("\n\r", '\n', "\r"), '<br />', $this->data['User']['notes']);
		}

		return $result;
	}
	function afterSave($created) {
		$this->deleteCache4User();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4User();

		return parent::afterDelete();
	}


	/* validation */
	function betweenUsername($data)
	{
		$idLength = Configure::read('User.UserId.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenPassword($data)
	{
		$idLength = Configure::read('User.Password.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenWrapper($data, $idLength)
	{
		$check = array_values($data);

		return parent::betweenWrapper($check[0], $idLength['min'], $idLength['max']);
	}

	/* キャッシュ削除 */
	function deleteCache4User()
	{
		// 自セッション関連
		$this->deleteCacheMyData($this->id);

		$this->deleteCacheHome();
		$this->deleteCacheUser($this->id);
	}


}
