<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class SiteConfig extends AppModel {

	var $name = 'SiteConfig';

	var $default_values = array(
		'Site.siteName' => array(
			'id' => null,
			'value' => 'TRPG Data Bank'
		),
		'Site.siteDescription' => array(
			'id' => null,
			'value' => ''
		),
		'Site.adminAddress' => array(
			'id' => null,
			'value' => 'admin@example.com'
		),
		'Site.useContact' => array(
			'id' => null,
			'value' => false
		),
		'Site.myHome' => array(
			'id' => null,
			'value' => 1
		),
		'Site.outerHome' => array(
			'id' => null,
			'value' => ''
		),
		'Site.outerHomeLinkname' => array(
			'id' => null,
			'value' => 'Back'
		),

		'Info.help' => array(
			'id' => null,
			'value' => ''
		),
		'Info.userAgreement' => array(
			'id' => null,
			'value' => ''
		),
		'Info.privacyPolicy' => array(
			'id' => null,
			'value' => ''
		),

		'User.newUserRegist' => array(
			'id' => null,
			'value' => 1
		),
		'User.registMail' => array(
			'id' => null,
			'value' => 1
		),
/*
		'Site.limitDomain' => array(
			'id' => null,
			'value' => array(
			),
		),
*/

		'Character.ListSearchNotes' => array(
			'id' => null,
			'value' => 0
		),
		'Character.NotesSearch' => array(
			'id' => null,
			'value' => 1
		),
		'Character.listImage' => array(
			'id' => null,
			'value' => 2
		),
		'Character.maxPictures' => array(
			'id' => null,
			'value' => 8
		),
		'Character.listImageString' => array(
			'id' => null,
			'value' => 'View'
		),
		'Character.fullLengthView' => array(
			'id' => null,
			'value' => 0
		),

		'Upload.imagefile.FileSizeMax' => array(
			'id' => null,
			'value' => '800'
		),
		'Upload.imagefile.WidthMax' => array(
			'id' => null,
			'value' => '780'
		),
		'Upload.imagefile.HeightMax' => array(
			'id' => null,
			'value' => '1000'
		),

		'System.allowUserSheet' => array(
			'id' => null,
			'value' => 0
		),
		'System.otherSetting' => array(
			'id' => null,
			'value' => 0
		),
		'System.singleSystem' => array(
			'id' => null,
			'value' => ''
		),

		'Design.customCss' => array(
			'id' => null,
			'value' => null
		),

		'InsertHTML.pageTop.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.pageTop.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.naviBottom.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.naviBottom.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.overFooter.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.overFooter.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.pageBottom.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.pageBottom.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftTop.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftTop.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftMiddle1.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftMiddle1.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftBottom.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeLeftBottom.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightTop.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightTop.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightMiddle1.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightMiddle1.after' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightBottom.before' => array(
			'id' => null,
			'value' => ''
		),
		'InsertHTML.HomeRightBottom.after' => array(
			'id' => null,
			'value' => ''
		),
	);


	var $fields = array(
		'add' => array('key_name', 'value'),
		'edit' => array('value'),
		'escape' => array(
			'value' => array(
				'html' => false,
				'images' => false,
				'sctipts' => false,
			),
		)
	);

	var $validate = array(
		'key_name' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
	);

	/* コールバックメソッド */
	function afterSave($created) {
		self::deleteCacheAll();

		return parent::afterSave($created);
	}
}
