<?php
/**
 * PHP version 5
 *
 * @category Lib
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
/* 
 * 汎用関数
 */

class CorePlus extends Object {

	var $models = array();
	var $behavoirs = array();

	var $default_public_flags = array(
		'public_flag',
		'private',
	);

	var $default_status = array(
		'active',
		'inactive',
	);

	/* isOwner */
	function isOwner($data, $user_id)
	{
		if (!$user_id) {
			return false;
		}
		if (!isset($data['user_id']) || !$data['user_id']) {
			return false;
		}
		if ($data['user_id'] == $user_id) {
			return true;
		}

		return false;
	}

	// public_flagチェック
	function check_public_flag($data, $key = null)
	{
		$userid = null;
		if (isset($this->user_id)) {
			$userid = $this->user_id;
		} elseif (isset($user['User']['id'])) {
			$userid = $user['User']['id'];
		}
		if (self::isOwner($data, $userid)) {
			return true;
		}

		return self::check_public_flag2($data, $key);
	}
	function check_public_flag2($data, $key = null)
	{
		if ($data['public_flag'] == 'public') {
			return true;
		}

		return false;
	}
	/* public_flagの設定を、key->value(多言語化対応)に変換 */
	function set_publicflag($public_flags = array(), $options = array())
	{
		static $i18n_public_flag;

		if (!empty($i18n_public_flag)) {
			return $i18n_public_flag;
		}

		if (empty($public_flags)) {
			$public_flags = $this->default_public_flags;
		}

		if (!empty($options)) {
			$public_flags = array_merge($public_flags, $options);
		}

		foreach ($public_flags as $k => $v) {
			if ($v == 'public') {
				$i18n_public_flag[$v] = __('Public', true);
			} elseif($v == 'private') {
				$i18n_public_flag[$v] = __('Private', true);
			} elseif($v == 'all') {
				$i18n_public_flag[$v] = __('All', true);
			} else {
				$i18n_public_flag[$v] = $v;
			}
		}

		return $i18n_public_flag;
	}

	/* statusの設定を、key->value(多言語化対応)に変換 */
	function set_status($status_list = array(), $options = array())
	{
		static $i18n_status;

		if (is_array($i18n_status)) {
			return $i18n_status;
		}

		if (!empty($options)) {
			$i18n_status = $options;
		}

		if (empty($status_list)) {
			$status_list = $this->default_status;
		}

		foreach ($status_list as $k => $v) {
			if ($v == 'active') {
				$i18n_status[$v] = __('Active', true);
			} elseif($v == 'inactive') {
				$i18n_status[$v] = __('Inactive', true);
			} elseif($v == 'all') {
				$i18n_status[$v] = __('All', true);
			} else {
				$i18n_status[$v] = $v;
			}
		}

		return $i18n_status;
	}


	// $value[$key]が存在しかつ空ではない場合、値を返す
	function get_value($value, $key)
	{
		if (self::is_valid($value, $key)) {
			return Set::classicExtract($value, $key);
		} else {
			return null;
		}
	}

	// $value[$key]が存在しかつ空ではない
	function is_valid($value, $key)
	{
		if (!Set::check($value, $key)) {
			return false;
		}

		$keys = explode(".", $key);
		if (!is_array($keys)) {
			$keys = array($key);
		}

		$target = $value;
		foreach($keys as $k) {
			$target = $target[$k];
		}

		return !empty($target);
	}


	/* DB settings */
	function set_db_settings()
	{
		static $site_configs;
		if ($site_configs) {
			return $site_configs;
		}

		$this->SiteConfig = self::set_model('SiteConfig');

		$conditions = array();

		$db_data = $this->SiteConfig->find('all', array(
			'conditions' => $conditions,
			'fields' => array(
				'SiteConfig.id',
				'SiteConfig.key_name',
				'SiteConfig.value',
			),
			'recursive' => -1,
//			'order' => array('SiteConfig.key_name' => 'asc'), // MySQL Filesortの原因
		));

		$site_configs = array();
		foreach ($this->SiteConfig->default_values as $k => $v) {
			if ($match = Set::extract('/SiteConfig[key_name='.$k.']', $db_data)) {
				$site_configs[$k] = $match[0]['SiteConfig'];
			} else {
				$site_configs[$k] = $v;
			}
			$site_configs[$k]['value'] = $this->{$this->modelClass}->restore_html($site_configs[$k]['value'], false, false, false);

			Configure::write($k, $site_configs[$k]['value']);
		}

		return $site_configs;
	}

	/* set Outer Controller */
	function set_controller($controllerName)
	{
		if (isset($this->controller[$controllerName])) {
			return $this->controller[$controllerName];
		}

		$name = $controllerName;
		if (strpos($controllerName, '.')) {
			list($plugin, $name) = explode('.', $controllerName, 2);
		}
		$class = $name . 'Controller';

		App::import('Controller', $controllerName);
		$controller = new $class;

		return $this->controller[$controllerName] = $controller;
	}


	/* set Outer Model */
	function set_model($modelName)
	{
		if (isset($this->models[$modelName])) {
			return $this->models[$modelName];
		}

		$name = $modelName;
		if (strpos($modelName, '.')) {
			list($plugin, $name) = explode('.', $modelName, 2);
		}

		App::import('Model', $modelName);
		$model = new $name;
		
		return $this->models[$modelName] = $model;
	}

	/* set Outer Behavoir */
	function set_behavoir($behavoirName)
	{
		if (isset($this->behavoirs[$behavoirName])) {
			return $this->behavoirs[$behavoirName];
		}

		$name = $behavoirName;
		if (strpos($behavoirName, '.')) {
			list($plugin, $name) = explode('.', $behavoirName, 2);
		}
		$class = $name . 'Behavior';

		App::import('Behavior', $behavoirName);
		$behavoir = new $class;

		return $this->behavoirs[$behavoirName] = $behavoir;
	}

}

