<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileTableStaticsController extends AppController {

	var $name = 'ProfileTableStatics';
	var $helpers = array(
		'Profiledisp',
	);

	// POSTのTokenチェックをしないアクション
	var $disableTokenActions = array();

	function admin_edit($profile_table_id = null) {
		if (!$profile_table_id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid Static ProfileTable', true));
			$this->redirect(array('controller'=>'systems', 'action'=>'admin_index'));
		}
		$profileTable = $this->ProfileTableStatic->ProfileTable->find(
			'first',
			array(
				'conditions' => array(
					'ProfileTable.id' => $profile_table_id,
				),
				'fields' => '',
				'contain' => array(
					'Profile' => array(						'System',
					),
					'ProfileTableStatic',
				),
				'recursive' => 2,
			)
		);

		if (empty($profileTable['ProfileTable'])) {
			$this->Session->setFlash(__('Invalid ID.', true));
			$this->redirect(array('controller'=>'systems', 'action'=>'admin_index'));
		}

		// 「その他」システム設定
		$this->checkEditOtherSystem($profileTable['Profile']['system_id']);

		foreach ($profileTable['ProfileTableStatic'] as $k => $v) {
			if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
				$sort_order[$k] = $v['sort_order'];
			} else {
				$sort_order[$k] = 0;
			}
		}
		if (!empty($sort_order)) {
			$profileTable['ProfileTableStatic'] = $this->sort4sort_order($profileTable['ProfileTableStatic'], $sort_order);
		}

		if (!empty($this->data)) {
			// POSTデータ処理
			$this->_set_new_profile_table_static($profileTable['ProfileTable']['id']);

			$this->ProfileTableStatic->create();
			if ($this->ProfileTableStatic->saveAll(
				$this->data['ProfileTableStatic'],
				array(
					'validate' => 'first',
					'fieldList' => $this->ProfileTableStatic->fields['edit'],
				)
			)) {
				$this->Session->setFlash(__('The Static ProfileTable has been saved', true));
				$this->redirect(array('controller'=>'profile_table_statics', 'action'=>'admin_edit', $profile_table_id));
			} else {
				$this->Session->setFlash(__('The data could not be saved. Please, try again.', true));

				unset($this->data['ProfileTableStatic']['__Token']);
				$this->data['Profile'] = $profileTable['Profile'];
				$this->data['ProfileTable'] = $profileTable['ProfileTable'];
			}
		}
		if (empty($this->data)) {
			$this->data = $profileTable;
		}

		$sample = $this->ProfileTableStatic->ProfileTable->Profile->find(
			'first',
			array(
				'conditions' => array(
					'Profile.id' => $profileTable['Profile']['id'],
				),
				'contain' => array(
					'ProfileTable' => array(
						'ProfileTableStatic',
					),
				),
				'recursive' => 2,
			)
		);
		foreach ($sample['ProfileTable'] as $k => $v) {
			if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
				$sort_order2[$k] = $v['sort_order'];
			} else {
				$sort_order2[$k] = 0;
			}
		}
		if (!empty($sort_order2)) {
			$sample['ProfileTable'] = $this->sort4sort_order($sample['ProfileTable'], $sort_order2);
		}
		$this->set('sample', $sample);


		$this->set('title_for_layout', " - ". __('Edit Static ProfileTable', true));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid URL.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profileTableStatic = $this->ProfileTableStatic->find(
			'first',
			array(
				'conditions' => array(
					'ProfileTableStatic.id' => $id,
				),
				'contain' => array(
					'ProfileTable',
				),
				'recursive' => 1,
			)
		);
		if (empty($profileTableStatic)) {
			$this->Session->setFlash(__('Invalid ID.', true));
			$this->redirect(array('controller'=>'systems', 'action'=>'admin_index'));
		}

		if ($this->ProfileTableStatic->delete($id)) {
			$this->Session->setFlash(__('ProfileTable Static has deleted', true));
		} else {
			$this->Session->setFlash(__('The data has not been deleted', true));
		}

		$this->redirect(array('action'=>'admin_edit', $profileTableStatic['ProfileTable']['id']));
	}

	function _set_new_profile_table_static($profile_table_id)
	{
		if (!isset($this->data['ProfileTableStatic']) || empty($profile_table_id)) {
			return array();
		}

		foreach ($this->data['ProfileTableStatic'] as $k => $v) {
			if (isset($v['__Token'])) {
				continue;
			}

			// 空の値:name空の場合行削除
			if (!CorePlus::is_valid($v, 'title')) {
				unset($this->data['ProfileTableStatic'][$k]);
				continue;
			}

			$this->data['ProfileTableStatic'][$k]['profile_table_id'] = $profile_table_id;

			if (empty($v['sort_order'])) {
				$this->data['ProfileTableStatic'][$k]['sort_order'] = 0;
			}
		}
		unset($this->data['ProfileTableStatic']['__Token']);

	}

}

