<?php
/*
 * Crypt (PEAR::Crypt_Blowfish) Components
 */

App::import('Vendor', 'Crypt_Blowfish', array('file' => 'PEAR' . DS . 'Crypt' . DS . 'Blowfish.php'));
class CryptComponent extends Object {

	function &get_crypt_blowfish() {
		static $singleton;
		if (empty($singleton)) {
			$singleton = new Crypt_Blowfish(Configure::read('Security.salt'));
		}

		return $singleton;

	}

	function crypt($data){
		if (empty($data)) {
			return null;
		}
		$blowfish = $this->get_crypt_blowfish();

		return base64_encode($blowfish->encrypt($data));
	}

	function decrypt($data)
	{
		if (empty($data)) {
			return null;
		}
		$blowfish = $this->get_crypt_blowfish();

		return rtrim($blowfish->decrypt(base64_decode($data)));
	}

}
