<?php
/**
 * PHP version 5
 *
 * @category Config
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
/**
 * Media Plugin用
 * Uploadファイルの出力設定
 * 運用途中で変更した場合は、app/webroot/media/filter以下のディレクトリとファイルを全て削除して下さい。
 * 
 * より詳細な設定が必要な場合は、app/plugin/media/config/core.phpを編集して下さい
 */

/* 
 * 'xxs'～'xl'
 * 設定名。任意で設定を増やす事も可能(要表示側ソースの改修）
 * 'orig'
 * 原画と当寸法(追加設定改修）
 * 
 * 'convert' => $MimeType
 * 	$MimeType形式に変換して出力
 * 	例：JPEG指定 : $MimeType = 'image/jpeg'
 * 	　　PNG指定  : $MimeType = 'image/png'
 * 	　　原画のmimeTypeを維持したい場合 : $MimeType = 'original'(追加設定)
 * 
 * 'fitCrop' => array($width, $height)
 *	幅$width, 高さ$height(px)に縮小/拡大してトリミング（原画の幅か高さの長い方をカット）
 * 'fit' => array($width, $height)
 *	幅$width, 高さ$height(px)に縮小（アスペクト比保持、原画の幅か高さの長い方を設定値以内に縮小）
 * 'fitOutside' => array($width, $height)
 *	幅$width, 高さ$height(px)に縮小（アスペクト比保持、原画の幅か高さの短い方を設定値以内に縮小）
 * 'zoomCrop' => array($width, $height)
 *	画像の中心から幅$width, 高さ$height(px)でトリミング
 */

/* 画像 */
$xxs = array('convert' => 'original', 'fitCrop' => array(16, 16));
$xs = array('convert' => 'original', 'fit' => array(32, 32));
$s = array('convert' => 'original', 'fit' => array(64, 64));
$m = array('convert' => 'original', 'fit' => array(120, 120));
$l = array('convert' => 'original', 'fit' => array(150, 150));
$ll = array('convert' => 'original', 'fit' => array(180, 180));
$xl = array('convert' => 'original', 'fit' => array(300, 300));
$fullPicture_m = array('convert' => 'original', 'fit' => array(800, 650));
$fullPicture = array('convert' => 'original', 'fit' => array(525, 1000));
$orig = array('convert' => 'original');

Configure::write('Media.filter.image', compact('xxs', 'xs', 's', 'm', 'l', 'll', 'xl', 'fullPicture_m', 'fullPicture', 'orig'));
