/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
*/
/*****************
 *  JaveScriptライブラリ：ログ表示
 *****************/

// ログ取得
function getLog(isUpdate){
    var log = logfile+'?e='+dateD;
    $.ajax({
        type: "get",
        ifModified: true,
        cache: false,
        url: log,
        success: function(data){
        // 最新行番号の取得
        var last_id = 0;
        var nowData = $('.row').get();
        if (nowData) {
            if (flowDesc) {
                var latestData = nowData.shift();
            } else {
                var latestData = nowData.pop();
            }
            if (latestData != undefined) {
                last_id = latestData.id;
            }
        }

        // ログの成形
        var recent = data.split('\n');

        var text = new Array();
        var seFlg = false;
        var systemSeSetting = false;
        var userSetting = false;
        if (useSe && isUpdate) {
            var seSetting = $("#seSetting").attr("checked");
            if (seSetting) {
                systemSeSetting = $("#systemSeSetting").attr("checked");
                userSetting = $("#userSetting").attr("checked");
            }
        }
        for(var i=0;i<recent.length; i++){

            // 各行を<>で分割して配列に
            var unit = recent[i].split('<>');

            // データがなければ終了
            // last_idで終点判断
            if(unit[0] && last_id < unit[0]){
                text[i] = setLogData(unit);

                // SE
                if (useSe && !seFlg) {
                    if (!isIE) {
                        var isInputFocus = window.parent.document.getElementById("isInputFocus").checked;
                        if  (isInputFocus) {
                            seFlg = true;
                            continue;
                        }
                    }

                     if (systemSeSrc && systemSeSetting && unit[2] == systemName) {
                        document.getElementById('se').src = systemSeObj.src;
                        seFlg = true;
                    } else if (userSeSrc && userSetting && unit[2] != systemName && unit[1] != window.parent.document.getElementById("name_on").value) {
                        document.getElementById('se').src = userSeObj.src;
                        document.getElementById('se').data = userSeObj.src;
                        seFlg = true;
                    }
                }

            } else {
                break;
            }
        }

        if (!text.length) {
            return false;
        }

        //出力
        outputLog(text, deleteLastPastLog, isUpdate);

        // 在室表示
        showMember(true);

        if (!flowDesc) {
            if ($("#isScrollBottom").attr("checked")) {
                var windowBottomOffset = $('#isScrollBottom').offset().top;
                $('html,body').animate({scrollTop: windowBottomOffset}, 100);
            }
        }

    }
    });
}

// ログ出力
function outputLog(text, deleteLastLogFlg, isUpdate) {
    if (!text.length) {
        return false;
    }

    text = text.reverse();
    for(var i=0;i<text.length; i++){
        if (flowDesc) {
            $("#main_console").after(text[i]);
        } else {
            $("#pastlog").before(text[i]);
        }

        // ログを「流す」
        if (deleteLastLogFlg) {
            var rows = $(".row").get();
            if (rows.length > maxNum) {
                if (flowDesc) {
                    var delLine = rows.pop();
                } else {
                    var delLine = rows[0];
                }
                var id = "#"+delLine.id;
                $(id).remove();
            }
        
        }
    }
}

// 在室表示
function showMember(isLogin) {
    $.ajax({
        type: "get",
        ifModified: true,
        cache: false,
        url: now_member,
        success: function(data2){
        // ログの成形
            var member = data2.split('\n');
            var text2 = "";
            var unit2 = new Array();
            for(var i=0;i<member.length; i++){
                var unit2 = member[i].split('<>');
                 // データがなければ終了
                if(!unit2[0]){
                    $("#indi").html('');
                    break;
                }

                var mname = unit2[0];
                var mpwd = unit2[1];
                if (obfuscateLog == '1') {
                    mname = deObfLog(mname);
                    mpwd = deObfLog(mpwd);
                }

                if (isLogin || !unpublicLoginMember) {
//                    var text2 = text2+'<span id="'+mname+'" class="member" ondblclick="deleteMember(\''+mname+'\',\''+mpwd+'\');" onclick="inputWhisper(\''+mname+'\',\''+mpwd+'\');">'+mname+'</span>'+'<>';
                    var text2 = text2+'<span id="'+mname+'" class="member">'+mname+'</span>'+'<>';
                } else {
                    var text2 = text2+'<span class="member">****</span>'+'<>';
                }
                // my_hashに自分のハッシュ登録
                if (window.parent.document.getElementById("name_on").value && window.parent.document.getElementById("pwd_on").value && phpHtmlspecialchars(window.parent.document.getElementById("name_on").value, '')==mname) {
                    window.parent.document.getElementById("my_hash").value = mpwd;
                }
            }
            // 出力
            if (text2) {
                $("#indi").html(text2);
                clickMemberList();
            }
        }
    });
}

// リフレッシュ
function clearLog(){
    var log = logfile+'?e='+(new Date()).getTime();
    $(".row").remove();
    $(".break").remove();
    $.ajax({
        type: "get",
        ifModified: false,
        cache: false,
        url: log,
        success: function(data){
            var recent = data.split('\n');
            var text = new Array();
            for(var i=0;i<recent.length; i++){
                var unit = recent[i].split('<>');
                text[i] = setLogData(unit);
            }

            outputLog(text, deleteLastPastLog, false);

            fontSizeChange("0");
            lineSpaceChange("0");
        }
    });
}

// ログ行成形
function setLogData(unit) {

    if (!unit[0] || !unit[2] || !unit[4]) {
        return false;
    }
    //データの成形
    var name = unit[1];
    var pc = unit[2];
    pcType = pc;
    var color = unit[3];
    var com = unit[4];
    var d = new Date();
    d.setTime(unit[5]*1000);
    var year = d.getYear();
    if (year < 2000) { year += 1900;}
    var month = d.getMonth()+1;
    if (month < 10) { month = "0" + month;}
    var day = d.getDate();
    if (day < 10) { day = "0" + day;}
    var hour = d.getHours();
    if (hour < 10) { hour = "0" + hour;}
    var min = d.getMinutes();
    if (min < 10) { min = "0" + min;}
    var sec = d.getSeconds();
    if (sec < 10) { sec = "0" + sec;}
    var datetime = month+'/'+day+' '+hour+':'+min;
    if (showDatetimeYear) {
        datetime = year+'/'+datetime;
    }
    if (showDatetimeSecond) {
        datetime = datetime+':'+sec;
    }
    var whisper = 'n';
    if (unit[9] || unit[10]) {
        whisper = 'y';
        if (unit[8] && $(window.parent.document.getElementById("my_hash")).attr("value") == unit[8]) {
            whisper = 'to';
        }
        if (unit[10] && $(window.parent.document.getElementById("my_hash")).attr("value") == unit[10]) {
            whisper = 'from'
        }
    }
    var whisperFrom = unit[9];
    if(unit[11] == '1' && unit[12]) {
        var status = unit[12];
    }
    var isMobile = unit[13];

    if (obfuscateLog=='1') {
        name = deObfLog(name);
        pc = deObfLog(pc);
        com = deObfLog(com);
        if (whisperFrom) whisperFrom = deObfLog(whisperFrom);
        if (status) status = deObfLog(status);
    }

    // 行の成形
    if (unit[0]!='0' && whisper!='y') {
        row = '<div class="row" id="'+deObfLog(unit[0])+'">';
        var pcname = '【'+pc+'】';
        if (isMobile == '1'&& showMobileCom == '1') {
            pcname += '<img src="'+mobileIcon+'" alt="(M)">';
        }
        row += '<span style="font-weight:bold; color:'+color+';" id="pcname'+deObfLog(unit[0])+'" title="'+name+'">'+pcname+'</span>：';
        if (whisper=='to' || whisper=='from') {
            row += '<span style="color:'+systemColor+';">(';
            if (whisper=='to') row += whisperFrom+'さんへ';
            if (whisper=='from') row += pc+'さんから';
            row += 'のささやき) </span>';

        }
        if (!showDatetime) {
            row += '<span title="'+datetime+'">';
        }
        row += com;
        if (!showDatetime) {
            row += '</span>';
        }
        if (status) {
            row += ' <span style="color:#'+statusColor+';">('+status+')</span>';
        }
        if (showDatetime) {
            row += ' <span style="color:#'+systemColor+';"> ('+datetime+')</span>';
        }

        // 改行
        row += '<div class="break"';
        row += ' style="margin-top:'+document.getElementById("linespace").value+'px; margin-bottom:'+document.getElementById("linespace").value+'px;';
        var hrType = $('select#hr option:selected').val();
        row += ' border-bottom-style: '+hrType+';"';
        row += '></div>';
        row += '</div>';
    } else {
        var row = "";
    }
    return row;
}

// チャット画面文字サイズ変更
function fontSizeChange(size) {
    // 現在の文字サイズ
    var nowFontSize = parseInt(document.getElementById("fontsize").value, 10);
    // 変更後の文字サイズ
    var changedFontSize = nowFontSize + parseInt(size, 10);
    if (changedFontSize < 8 || changedFontSize > 24) {
        alert("これ以上変更できません");
        return false;
    }

    document.getElementById("fontsize").value = changedFontSize;
    $(".chatwindow").css("font-size", changedFontSize+"px");
}

// チャット画面行間隔変更
function lineSpaceChange(size) {
    // 現在の行間隔
    var nowSpace = parseInt(document.getElementById("linespace").value, 10);
    // 変更後の行間隔
    var changedSpace = nowSpace+size/2;
    if (changedSpace < 0 || changedSpace > 48) {
        alert("これ以上変更できません");
        return false;
    }

    document.getElementById("linespace").value = changedSpace;
    $(".break").css("margin-top", changedSpace+"px");
    $(".break").css("margin-bottom", changedSpace+"px");
}


// ささやき指定
function inputWhisper(name, whisperTo) {
    if (!userWhisper) {
        return false;
    }
    var flag = whisperTo ? true : false;
    if (flag==false){
        alert(name+"さんは入室パスワード未入力のため、「ささやき」はできません。");
    } else if (!window.parent.document.getElementById("pwd_on").value){
        alert("パスワードを入力しないと「ささやき」はできません。");
    } else if (name=='全員'){
        alert("「全員」さんに「ささやき」はできません(笑)");
    } else {
        window.parent.changeWhisperConfig(name, whisperTo);
    }
}

// 発言間ライン変更
function lineSpaceHrChange(SelectObj) {
    lineSpaneHrSelectChange(SelectObj);
    $(".break").css("border-style", SelectObj);
}
function lineSpaneHrSelectChange(val) {
    $("select#hr").val(val);
}

// 発言音設定
function seOn() {
    $("#seSetting").attr("checked", true);
    $("#seOn").hide();
    $("#seOff").hide();
    seConfigShow();
}
function seOff() {
    $("#seSetting").attr("checked", false);
    $("#seOn").hide();
    $("#seOff").show();
    $("#seConfig").hide();
}
function seConfigShow() {
    $("#seConfig").show();
    $("#seSelect").show();
}
function seConfigHide() {
    if (!$("#systemSeSetting").attr("checked") && !$("#userSetting").attr("checked")) {
        $("#seSetting").attr("checked", false);
    }

    $("#seConfig").hide();
    $("#seSelect").hide();

    if ($("#seSetting").attr("checked")) {
        $("#seOn").show();
        $("#seOff").hide();
    } else {
        $("#seOn").hide();
        $("#seOff").show();
    }
}

// ウインドウサイズ変更でフォームサイズ変更
function changeSize() {
    var winWidth = getWinWidth();
    var winHeight = getWinHeight() - 80;
    if (useSe) {
        $("#seSelect").css({left: winWidth-250});
    }
}

// 参加者名クリック
function clickMemberList() {
    $(".member").click(function(ev){
        inputWhisper($(this).attr("id"),'');
    }
    );
    $(".member").contextmenu(function(ev){
        deleteMemberConfirm($(this).attr("id"));
        return false;
    }
    );
}

// 参加者一覧からメンバー削除：入力
function deleteMemberConfirm(name) {
    if (name=="") {
        return false;
    }

    // 確認画面表示
    var deletConfirm = window.confirm(name+"さんを参加者一覧から削除しますか？");

    if (!deletConfirm) {
        return false;
    }

    var deletePassword = window.prompt("入室時のパスワードを入力してください。\n入力していなかった場合は空で送信してください。", "");
    if (deletePassword == null) {
        return false;
    }
    var exeName = window.prompt("メンバー削除はチャットに記録されます。\nあなたのお名前を入力してください。", "");
    if (exeName == null) {
        return false;
    }
    if (exeName == "") {
        alert("お名前の入力は必須です。");
        return false;
    }

    // 削除はPHP側で判断（マスターパス削除用）
    deleteMember(name, deletePassword, exeName);

}

// 参加者一覧からメンバー削除：実行
function deleteMember(name, deletePassword, exeName) {
    var script = './member_delete.php';
    var params1 =
        '?n='+name//削除対象
        +'&pwd='+deletePassword
        +'&en='+exeName//実施者名
    $.ajax({
        type: "get",
        url: script+params1,
        ifModified: false,
        cache: false,
        dataType: "text",
        success: function(data) {
            // 削除完了
            if (data=='deleted') {
                showMember(true);
                var params =
                    '?n='+exeName//名前
                     +'&s='+'0'//状態表示
                     + '&dn='+name
                     +'&y=delMember'
                     +'&e='+(new Date()).getTime();//cacheの更新
                $.ajax({
                    type: "GET",
                    url: writescript+params,
                    success: function(data) {
                        getLog(true);
                    }
                });
            } else {
                alert('削除に失敗しました。');
            }
            return false;
        },
        error: function(data) {
            alert(data);
            return false;
        }
    });
}
