<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// かんたんセットアップ対応
require_once './lib/trpgchat.php';
require_once './trpgchat-ini-2.php';
if (!file_exists('./trpgchat-ini.php')) {
    if (!file_exists('./setup.php')) {
        error('setup.phpがありません。ディレクトリを確認してください。', false, false, true);
    }
    $self_url = get_self_url();
    $url =str_replace('index.php', 'setup.php', $self_url);
    header('Location: '.$url);
    exit;
}
if (file_exists('./setup.php')) {
    error('setup.phpを移動するか、または名前を変えてください。', false, false, true);
}

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/ini/trpgchat-ini-help.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// 携帯は携帯INDEXへ
// 後日実装

// HTML出力
print html_header(CHAT_TITLE, 'index', true, true);

// COOKIE読み込み
$cookies = read_cookie();

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/index-js.php';

?>
</head>
<body onblur="inputBlur()" onresize="changeSize()" onunload="UnLoad()">

<input id="isInputFocus" type="checkbox" class="nodisplay">

<?php
// 操作欄
if (UPPER_USER_PANEL) {
    include './index_inc_userpanel.php';
}
 ?>

<div>
<?php
// コンソール
// ヘルプ
write_console('55px', '-400px', '350px', 'none', 'help_win', 'ヘルプ', HELP_MSG.$GLOBALS['AJAX_CHAT_TRPG']['STATIC_HELP'], $GLOBALS['AJAX_CHAT_TRPG']['ACCORDION_HELP'], '', false);
// 入室前表示
if (OFFWINDOW_MSG || (UNPUBLIC_LAST_PASTLOG && NO_LAST_PASTLOG_MSG)) {
    $off_msg = OFFWINDOW_MSG;
    if (UNPUBLIC_LAST_PASTLOG) $off_msg .= NO_LAST_PASTLOG_MSG;
    write_console('30px', '-330px', '250px', '', 'offline_win', '', nl2br($off_msg), array(), '', false);
}
// クッキーをファイルから読む
if (COOKEI_EXPIRE && COOKIE) {
    $body = '<div class="nodisplay">'.
            '<form id="cookieFrame" action="./cookie_load.php" method="POST" enctype="multipart/form-data" onsubmit="if(!isFile(\'#cookieFileName\')){return false;};">'.
            '</div>'.
            '<input type="file" name="cookieFileName" id="cookieFileName">'.
            '<input type="hidden" name="MAX_FILE_SIZE" value="300000" />'.
            '<input type="submit" value="読み込む"> '.
            '<input type="reset" value="やめる" onclick="hideTarget(\'load_cookie\')">'.
            '<div class="nodisplay"></form></div>';
    write_console('35px', '0px', '200px', 'none', 'load_cookie', '設定をファイルから読み込む', $body, '', '', false);

}

?>
</div>
<iframe src="./main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:500px;" id="mainframe"></iframe>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です</p>
</noscript>

<?php

// 操作欄
if (!UPPER_USER_PANEL) {
    include './index_inc_userpanel.php';
}

// フッター
print html_footer(true, true);

exit;
 ?>