/*
 * Ajax Chat for TRPG ver.2.4
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*****************
 *  JaveScriptライブラリ：index.php用
 *****************/

// 発言成形
function comment(Obj) {
    // 発言取得
    var pc_input = Obj.pc_input.value;
    if (pc_input) {
        //入力チェック
        var name = convert($("#name_on").attr("value"));
        var pc_name = Obj.pc_name.value;
        if (!pc_name) {
            alert("PC名を入力してください。");
            return false;
        }
        var pc_color = Obj.pc_color.value;

        //データ成形
        var params =
            '?n='+name//名前
            +'&c='+convert(pc_name)//PC
            +'&l='+pc_color//色
            +'&m='+convert(pc_input);//本文

        // ささやき
        var whisper_to_name = $("#whisper_to").attr("value");
        var whisper_to_hash = $("#whisper_to_hash").attr("value");
        if(whisper_to_name && whisper_to_name != '全員' && whisper_to_hash) {
            params = params
                +'&w='+convert(whisper_to_name)//whisperto
                +'&h='+whisper_to_hash;//whisperto_hash
        }

        //状態表示
        if (Obj.show_status.checked) {
            params = params+'&s='+'1';
        } else {
            params = params+'&s='+'0';
        }

        //状態
        if (Obj.status.value) {
            params = params+'&t='+convert(Obj.status.value);
        }

        //他
//        params = params+'&a='+Obj.status.value;

        if ($("#pwd_on").attr("value")) {
            var pwd = convert($("#pwd_on").attr("value"));
        }
        if(pwd) {
            var params =
            params+'&p='+pwd;//PWD
        }
        var params =
            params+'&y=com'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        Obj.pc_input.value = "";
    }
    Obj.pc_input.focus();

    return false;
}

// 書き込み
function writeComment(params)
{
    $.ajax({
        type: "GET",
        url: writescript+params,
        success: function() {
    // 受信完了イベント
            window.mainframe.getLog();
        }
    });
}

// 在室確認
function isMember(name){
    var member = $(window.mainframe.document.getElementById("indi")).text();

    var name_array = member.split('<>');
    for (i=0;i<name_array.length;i++) {
        if (name_array[i] == name) {
            return true;
        }
    }
}


// カーソル位置に指定文字列を挿入
function insert(Obj, selfId, text, backlength) {
    // 自分自身には挿入できない(ダイスショートカット対応）
    if (Obj.id == selfId) {
        return false;
    }

    Obj.focus();

    var textLength = text.length;
    //FireFoxなど
    if (Obj.selectionStart) {
        var position = Obj.selectionStart;
        Obj.value = Obj.value.substring(0, position)+text+Obj.value.substring(position, Obj.value.length);
        Obj.setSelectionRange(position + textLength, position + textLength - backlength);
    } else {
        // IE
        if (document.selection) {
            var sel = document.selection.createRange();
            sel.text = text;
            sel.move('character', -backlength);
            sel.select();
        // その他
        } else {
            Obj.value = Obj.value+text;
        }
    }
}

// 名前文字色を反映
function changeColor(Obj1, Obj2, Ev) {
    if(Ev != "37" && Ev != "39" && Ev != "8" && Ev != "16" && Ev != "17" && Ev != "18"){
        Obj2.pc_color.style.color = Obj1.value;
        Obj2.pc_color.value = Obj1.value;
        Obj2.pc_color_select.style.color = Obj1.value;
        Obj2.pc_name.style.color = Obj1.value;
    }
}

// タグ挿入
function insertTag(tag, columnId) {
    insert(document.getElementById(columnId), '','<'+tag+'></'+tag+'>', tag.length+3)
}

// フォントタグ挿入
function insertFontTag(columnId) {
    var size = prompt("フォントサイズを指定してください(1～7または-4～+4)", "");
    var color = prompt("フォント色を指定してください", "");

    if (!size && !color) {
        return false;
    } else {
        var tag = "<font";
        if (size) {
            tag= tag+" size="+size;
        }
        if (color) {
            tag= tag+" color="+color;
        }
        tag = tag+"></font>";
        insert(document.getElementById(columnId), '', tag, 7)
    }
}

// 直前に選択していた欄のIDとカーソル位置を記録
function selectedColumnId(Obj1, Obj2) {
    if (Obj1) {
        columnId = Obj1.id;
    }
    if (Obj2.pc_color) {
        pcColorId = Obj2.pc_color.id;
    }
}

// 入室中にリロード・ページ遷移で自動退室
function UnLoad() {
    var name = $("#name_on").attr("value");
    if (name && isMember(name)==true) {
        $("#logout").click();
    }
}

// 起動時表示系処理
function pageLoad() {
    // フォームON/OFF
    $("#online1").hide();
    $("#online2").hide();
    $("#cfchange").hide();
    if (document.getElementById("cfinput")) { 
        document.getElementById("cfinput").checked = false;
    }
    document.getElementById("name_on").disabled = true;
    document.getElementById("pwd_on").disabled = true;
    document.getElementById("my_hash").disabled = true;
    document.getElementById("name_on").value = "";
    document.getElementById("pwd_on").value = "";
    document.getElementById("my_hash").value = "";
    if (userWhisper) {
        document.getElementById("whisper_to").disabled = true;
        document.getElementById("whisper_to").value = "全員";
    }

    // コンソール窓設定
    ddHelp = new YAHOO.util.DD("help_win");
    $("#help_win").css({left: document.body.clientWidth-380});
}

// ログイン
function doLogin(name, pwd) {
    if (!name || name == noname) {
        alert("お名前を入力してください。");
        return false;
    }
    //現在の入室者と同じ名前ではログインできない
    if (isMember(name)==true) {
        alert("現在の参加者と同じ名前ではログインできません。");
        return false;
    }

    //データ成形
    var params =
        '?n='+convert(name)//名前
        +'&s='+'0';//状態表示
    var params =
        params+'&p='+convert(pwd);//PWD

    var params =
        params+'&y=in'
        +'&e='+(new Date()).getTime();//cacheの更新
     writeComment(params);

    return true;
}

// ログアウト
function doLogout(name) {
    //データ成形
    var params =
        '?n='+name//名前
        +'&s='+'0'//状態表示
    if($("#pwd_on").attr("value")) {
        var params =
        params
        +'&p='+convert($("#pwd_on").attr("value"));//PWD
    }
    var params =
        params+'&y=out'
        +'&e='+(new Date()).getTime();//cacheの更新

    writeComment(params);
}
