<?php

class pc_page_h_access_ranking extends OpenPNE_Action
{
    function execute($requests)
    {
        if (!LOG_C_ACCESS_LOG) {
            exit('この機能は現在ご利用できません');
        }

        $u = $GLOBALS['AUTH']->uid();

        // --- リクエスト変数
        $ymd = $requests['ymd'];
        $range = $requests['range'];
        $page_size = $requests['page_size'];
        //----------リクエスト変数-------------//

        $this->set('inc_navi', fetch_inc_navi("h"));

        // パラメータチェック
        if ($ymd) {
            $timestamp = strtotime($requests['ymd']);
        } else {
            $timestamp = time();
        }

       // 期間ランキング表示
       list($ranking_diary, $title) = p_access_ranking_diary($timestamp, $range, $page_size);

        $this->set('range', $range);
        $this->set('ranking_diary', $ranking_diary);
        $this->set('title', $title);
        $this->set('ranking_datetime', date('Y/m/d H:i:s', $timestamp));

        // 日記に貼り付け
        switch ($range) {
            case 'yesterday':
            case 'lastweek':
            case 'lastmonth':
                $params = array();
                if ($ymd) {
                    $params['ymd'] = $ymd;
                }
                if ($range) {
                    $params['range'] = $range;
                }
                if ($page_size) {
                    $params['page_size'] = $page_size;
                }
                $url = openpne_gen_url('pc', 'page_h_access_ranking', $params, true);
                $this->set('ranking_url', $url);
                break;
        }

        return 'success';
    }
}

/* 日記アクセスランキング出力関数 */
function p_access_ranking_diary($timestamp, $range, $page_size=10)
{
    static $is_recurred = false;  //再帰処理中かどうかの判定フラグ

    if (!$is_recurred) {  //function cacheのために再帰処理を行う
        $is_recurred = true;
        $funcargs = func_get_args();
        switch ($range) {
            case 'dairy':
            case 'weekly':
            case 'monthly':
                return pne_cache_recursive_call(OPENPNE_FUNCTION_CACHE_LIFETIME_FAST, __FUNCTION__, $funcargs);
                break;
            case 'yesterday':
            case 'lastweek':
            case 'lastmonth':
                return pne_cache_recursive_call(OPENPNE_FUNCTION_CACHE_LIFETIME_LONG, __FUNCTION__, $funcargs);
                break;
            default:
                return false;
                break;
        }
    }

    $is_recurred = false;

    $dateArr = getdate($timestamp);

    switch ($range) {
        case 'dairy':
            $start_timestamp = $timestamp - 60*60*24*1;
            $end_timestamp = $timestamp + 1;
            $title = '24時間以内の';
            break;
        case 'weekly':
            $start_timestamp = $timestamp - 60*60*24*7;
            $end_timestamp = $timestamp + 1;
            $title = '過去7日間の';
            break;
        case 'monthly':
            $start_timestamp = $timestamp - 60*60*24*30;
            $end_timestamp = $timestamp + 1;
            $title = '過去30日間の';
            break;
        case 'yesterday':
            $start_timestamp = mktime(0, 0, 0, $dateArr['mon'], $dateArr['mday']-1, $dateArr['year']);
            $end_timestamp = mktime(0, 0, 0, $dateArr['mon'], $dateArr['mday'], $dateArr['year'], $timestamp);
            $title = date('n/j', $start_timestamp).'の';
            break;
        case 'lastweek':
            $start_timestamp = mktime(0, 0, 0, $dateArr['mon'], $dateArr['mday']-7-$dateArr['wday'], $dateArr['year'], $timestamp);
            $end_timestamp = mktime(0, 0, 0, $dateArr['mon'], $dateArr['mday']-$dateArr['wday'], $dateArr['year'], $timestamp);
            $title = date('n/j', $start_timestamp).'～'.date('n/j', $end_timestamp).'の';
            break;
        case 'lastmonth':
            $start_timestamp = mktime(0, 0, 0, $dateArr['mon']-1, 1, $dateArr['year'], $timestamp);
            $end_timestamp = mktime(0, 0, 0, $dateArr['mon'], 1, $dateArr['year'], $timestamp);
            $title = date('n', $start_timestamp).'月の';
            break;
        default:
            return false;
            break;
    }
    $start_datetime = date('Y-m-d H:i:s', $start_timestamp);
    $end_datetime = date('Y-m-d H:i:s', $end_timestamp);
    $title = $title. WORD_DIARY. 'ランキング';

    $sql = "select target_c_diary_id , count(*) as count from c_access_log";

    if ($range) {
        $sql .= " where r_datetime >= ? and r_datetime < ? ";
    }
    $sql .= " and target_c_diary_id <> 0 ";
    $sql .= " group by target_c_diary_id ";
    $orderby_str = " order by count desc";
    $sql .= $orderby_str;
    $params = array($start_datetime, $end_datetime);
    $list = db_get_all_limit($sql, 0, $page_size, $params);

    $return = array();
    if ($list) {
        $rank = 1;
        $current_count = null;
        foreach ($list as $key => $value) {
            if ($value['count'] != $current_count) {
                $rank += count($return[$rank]);
                $current_count = $value['count'];
            }
            if ($c_diary = db_diary_get_c_diary4id($value['target_c_diary_id'])) {
                $c_member = db_member_c_member4c_member_id($c_diary['c_member_id']);
                $c_diary['nickname'] = $c_member['nickname'];
                $c_diary['image_filename'] = $c_member['image_filename'];
                $value['is_c_diary_exists'] = true;
                $return[$rank][] = array_merge($value, $c_diary);
            } else {
                $value['is_c_diary_exists'] = false;
                $return[$rank][] = $value;
            }
        }
    }
    return array($return, $title);
}

?>
