<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// パスワードの照合
auth();

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';


// 画面表示：HTML出力
print html_header(TITLE.' 過去ログ管理画面', 'main', false, true);

?>
</head>
<body>
<h2 align="center"><?php print TITLE; ?> 過去ログ管理画面</h2>

<?php
if ($request['msg']) print '<p style="color:red">'.$request['msg'].'</p>';
?>

<table cellspacing="0" align="center" border="1" bordercolor="#000000">
<tr><td colspan="2">
<div style="color:blue;" align="center"><b>過去ログ作成</b></div>
<form action="./pastlog_create.php" method="<?php print METHOD; ?>" name="write_log">
<table align="center" border="0">
<tr>
<td><input type="checkbox" name="datetime" value="1">
発言時間表示</td>
<td><input type="checkbox" name="whisper" value="1">ささやき全表示</td>
<td><input checked type="checkbox" name="delete" value="1">ログ削除</td>
</tr>
<tr><td colspan="3" align="center">ログファイル名：<input name="filename" type="text" value="<?php print date('Ymd'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">.html　<input type="submit" value="過去ログ作成"></td></tr>
</table></form>
<span align="left">「ささやき全表示」：指定すると公開ログにも全ての「ささやき」が表示されます。<br>
「ログ削除」：過去ログ作成と同時に、現在のログを全て削除します。<br></span>
<hr>
<div style="color:blue;" align="center"><b>ディレクトリ編集</b></div>
<form action="./pastlog_edit_dir.php" method="<?php print METHOD; ?>">
<table align="center" border="0">
<tr><td align="center">ディレクトリ名：<input name="dirname" type="text" value="<?php print date('Ym'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">　対象<input name="type" type="radio" value="<?php print $past_dir; ?>" checked>公開側<input name="type" type="radio" value="<?php print $master_past_dir; ?>">管理側</td></tr>
<tr><td align="right"><input type="submit" name="mode" value="新規作成">　<input type="submit" name="mode" value="削除"></td></tr>
<tr>
<td align="right" nowrap>変更後ディレクトリ名：<input name="dirname_new" type="text" value="" size="10" maxlength="30" style="ime-mode:disabled;">　<input type="submit" name="mode" value="変更"></form></td></tr>
</table>
<span align="left">過去ログ整理用ディレクトリを作成します。<br>
ディレクトリ階層は、１階層のみ有効です。<br>
過去ログファイルがあるディレクトリは削除できません。<br>
ディレクトリ名に使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。<br>
</span>

</td></tr>

<tr>
<td valign="top" width="50%">
<h4>公開過去ログ</h4>

<?php
print_pastlog_contents_list($past_dir, 'root', 'ASC', true, './pastlog_edit_file.php');
?>
</td>
<td valign="top" width="50%">
<h4>管理用過去ログ(非公開)</h4>

<?php
print_pastlog_contents_list($master_past_dir, 'root_past', 'ASC', true, './pastlog_edit_file.php', '_past');
?>

<h5>管理用過去ログには、全ての発言時間・ささやき・参加者のホスト情報が記録されます</h5>

</td>
</tr>
</table>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">過去ログ管理機能は、JavaScript不可の環境では使用できません。</p>
</noscript>

<?php
// フッター
print html_footer();


?>