/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter.emp;

import com.ozacc.mail.trotter.emp.MailInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

class Mail
implements MailInfo,
Serializable {
    private String id;
    private String email;
    private String subject;
    private Date date;
    private String content;
    private MimeMessage message;

    public String getEmail() {
        return this.email;
    }

    public String getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setDelete(boolean bl) {
        try {
            this.message.setFlag(Flags.Flag.DELETED, bl);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
        this.parse();
    }

    void parse() {
        if (this.content == null) {
            return;
        }
        this.content = this.content.replaceAll("\r\n", "\n");
        this.content = this.content.replaceAll("\r", "");
        this.parseTo();
        this.parseDate();
    }

    private void parseDate() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.content, "\n");
        Pattern pattern = Pattern.compile("^(> )?Date: ([a-zA-Z]{3}, \\d{1,2} [a-zA-Z]{3} \\d{4} \\d{2}:\\d{2}:\\d{2} [+\\-]\\d{4})");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = matcher.group(2);
            this.date = this.formatDate(string2);
        }
    }

    private Date formatDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    private void parseTo() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.content, "\n");
        Pattern pattern = Pattern.compile("^(>\\s)?To:\\s*<?([\\w-.]+@[\\w-.]+\\.[a-zA-Z]{2,4})>?");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            this.email = matcher.group(2);
        }
    }

    public void addMessage(MimeMessage mimeMessage) {
        this.message = mimeMessage;
    }
}

