/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ConfigParser;
import com.ozacc.mail.trotter.JDOMConfigParser;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.ListReaderFactory;
import com.ozacc.mail.trotter.Person;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.internet.AddressException;

public class Validator {
    private String configFileName;
    private Config config;

    public void setConfigFileName(String string) {
        this.configFileName = string;
        this.readConfig();
    }

    private void readConfig() {
        try {
            JDOMConfigParser jDOMConfigParser = new JDOMConfigParser();
            this.config = ((ConfigParser)jDOMConfigParser).parse(new File(this.configFileName));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Config getConfig() {
        return this.config;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Validator.printUsage();
            return;
        }
        Validator validator = new Validator();
        validator.setConfigFileName(stringArray[0]);
        Config config = validator.getConfig();
        System.out.println(stringArray[0] + "\u306e\u8a2d\u5b9a\u5185\u5bb9");
        System.out.println("--------------------------------------------");
        System.out.println("SMTP\u30b5\u30fc\u30d0: " + config.getHost());
        System.out.println("\u30dd\u30fc\u30c8\u756a\u53f7: " + config.getPort());
        System.out.println();
        System.out.println("\u9001\u4fe1\u8005\u540d: " + config.getSenderName());
        System.out.println("\u9001\u4fe1\u8005\u30a2\u30c9\u30ec\u30b9: " + config.getSenderAddress());
        System.out.println();
        System.out.println("\u30e1\u30fc\u30eb\u306e\u4ef6\u540d: " + config.getSubject());
        System.out.println();
        System.out.println("Return-Path: " + config.getReturnPath());
        System.out.println("\u9001\u4fe1\u9593\u9694: " + config.getInterval() + "ms");
        System.out.println("--------------------------------------------");
        System.out.println("\u30ea\u30b9\u30c8\u30bf\u30a4\u30d7: " + config.getListType());
        if (config.getListType().equals("csv")) {
            Validator.printCSVConfig(config);
        } else if (config.getListType().equals("plain")) {
            Validator.printPlainConfig(config);
        }
        if (validator.validate()) {
            System.out.println("--------------------------------------------");
            System.out.println("\u30c1\u30a7\u30c3\u30af\u306e\u7d50\u679c\u3001\u30a8\u30e9\u30fc\u306f\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        } else {
            System.out.println("--------------------------------------------");
            System.out.println("\u30c1\u30a7\u30c3\u30af\u306e\u7d50\u679c\u3001\u4e0a\u8a18\u306e\u30a8\u30e9\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002");
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java com.ozacc.bulkmail.Validator <config.xml>");
    }

    private static void printPlainConfig(Config config) {
        System.out.println("\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb: " + config.getListFileName());
        System.out.println();
    }

    private static void printCSVConfig(Config config) {
        List list = config.getColumnList();
        int n = list.size();
        System.out.println("CSV\u30d5\u30a1\u30a4\u30eb: " + config.getListFileName());
        System.out.print("CSV\u69cb\u6210: ");
        for (int i = 0; i < n; ++i) {
            Column column = (Column)list.get(i);
            System.out.print(column.getName());
            if (i + 1 != n) {
                System.out.print(", ");
                continue;
            }
            System.out.println();
        }
        System.out.println();
    }

    public boolean validate() {
        boolean bl = true;
        ListReaderFactory listReaderFactory = new ListReaderFactory();
        ListReader listReader = listReaderFactory.newListReader(this.config);
        try {
            listReader.open();
        }
        catch (IOException iOException) {
            System.out.println("[WARNING]\u3000" + iOException.getMessage());
            return false;
        }
        int n = 0;
        Person person = null;
        while (listReader.hasNext()) {
            ++n;
            try {
                person = listReader.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = false;
                System.out.println("[WARNING]\u3000" + n + "\u884c\u76ee: " + noSuchElementException.getMessage());
            }
            try {
                person.getInternetAddress();
            }
            catch (AddressException addressException) {
                bl = false;
                System.out.println("[WARNING]\u3000" + n + "\u884c\u76ee: " + addressException.getMessage());
            }
        }
        System.out.println();
        System.out.println("\u5168\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9\u6570: " + n);
        return bl;
    }
}

