/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ConfigParser;
import com.ozacc.mail.trotter.JDOMConfigParser;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.ListReaderFactory;
import com.ozacc.mail.trotter.SendMailImpl;
import com.ozacc.mail.trotter.SendMailWithReplace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.mail.MessagingException;

public class Trotter {
    private Config config;
    private String body;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            Trotter.printUsage();
            return;
        }
        Trotter trotter = new Trotter();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("-c")) {
                trotter.getConfig(stringArray[i + 1]);
                continue;
            }
            try {
                trotter.readBody(stringArray[i], null);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        System.out.println("Start Delivering...");
        try {
            trotter.execute();
        }
        catch (MessagingException messagingException) {
            System.err.println("Error Occured.  Stop Delivering.");
            System.err.println(messagingException.getMessage());
            return;
        }
        System.out.println("Complete Delivering!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() throws MessagingException {
        SendMailImpl sendMailImpl = null;
        ListReader listReader = null;
        if (this.config == null) {
            return;
        }
        try {
            try {
                sendMailImpl = this.config.needReplace() ? new SendMailWithReplace() : new SendMailImpl();
                if (this.body == null) {
                    this.readBody(this.config.getBodyFileName(), this.config.getBodyEncoding());
                }
                sendMailImpl.setConfig(this.config);
                sendMailImpl.setBody(this.body);
                ListReaderFactory listReaderFactory = new ListReaderFactory();
                listReader = listReaderFactory.newListReader(this.config);
                listReader.open();
                sendMailImpl.connect();
                while (listReader.hasNext()) {
                    sendMailImpl.send(listReader.next());
                }
                Object var5_5 = null;
            }
            catch (Exception exception) {
                throw new MessagingException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (sendMailImpl != null) {
                    sendMailImpl.close();
                }
                listReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (sendMailImpl != null) {
            sendMailImpl.close();
        }
        listReader.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readBody(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            try {
                String string3;
                bufferedReader = string2 == null ? new BufferedReader(new FileReader(string)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string3 + "\n");
                }
                this.body = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new IOException("\u672c\u6587\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedReader == null) return;
        bufferedReader.close();
        return;
    }

    private String getBody() {
        return this.body;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: java com.ozacc.bulkmail.BulkMailer -c config.xml -l emaillist body.txt");
        System.out.println();
    }

    private void getConfig(String string) {
        try {
            JDOMConfigParser jDOMConfigParser = new JDOMConfigParser();
            this.config = ((ConfigParser)jDOMConfigParser).parse(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

