/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.Person;
import com.ozacc.mail.trotter.SendMailImpl;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.internet.AddressException;

class SendMailWithReplace
extends SendMailImpl {
    private String body;

    SendMailWithReplace() throws NoSuchProviderException {
    }

    public void setBody(String string) {
        this.body = string;
    }

    public synchronized void send(Person person) throws MessagingException {
        ++count;
        String string = null;
        List list = this.config.getReplaceColumnList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (string == null) {
                string = this.body.replaceAll(column.getSource(), person.get(column.getName()));
                continue;
            }
            string = string.replaceAll(column.getSource(), person.get(column.getName()));
        }
        try {
            if (string != null) {
                this.mail.setText(string, "ISO-2022-JP");
            } else {
                this.mail.setText(this.body, "ISO-2022-JP");
            }
            this.mail.setHeader("Content-Transfer-Encoding", "7bit");
            this.mail.setRecipient(Message.RecipientType.TO, (Address)person.getInternetAddress());
            this.mail.setSentDate(new Date());
            this.mail.saveChanges();
            this.transport.sendMessage((Message)this.mail, this.mail.getAllRecipients());
            this.log.info((Object)(count + " Send OK\t" + person));
            if (this.config.isMonitored()) {
                System.out.println(count + ": " + person);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (AddressException addressException) {
            this.log.warn((Object)(count + " Send Error (" + addressException.getMessage() + ")\t" + person));
        }
        catch (MessagingException messagingException) {
            this.log.fatal((Object)(count + " Fatal Error (SMTP\u30b5\u30fc\u30d0\u3068\u306e\u3084\u308a\u3068\u308a\u306e\u4e2d\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u914d\u4fe1\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002"));
            throw new MessagingException("SMTP\u30b5\u30fc\u30d0\u3068\u306e\u3084\u308a\u3068\u308a\u306e\u4e2d\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }
}

